/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hedwig.util;

import java.net.InetSocketAddress;

public class HedwigSocketAddress {
    private final String hostname;
    private final int port;
    private final int sslPort;
    private final InetSocketAddress socketAddress;
    private final InetSocketAddress sslSocketAddress;
    public static final String COLON = ":";
    private static final int NO_SSL_PORT = -1;

    public HedwigSocketAddress(String hostname, int port, int sslPort) {
        this.hostname = hostname;
        this.port = port;
        this.sslPort = sslPort;
        this.socketAddress = new InetSocketAddress(hostname, port);
        this.sslSocketAddress = sslPort != -1 ? new InetSocketAddress(hostname, sslPort) : null;
    }

    public HedwigSocketAddress(String hostname, int port) {
        this(hostname, port, -1);
    }

    public HedwigSocketAddress(String addr) {
        String[] parts = addr.split(COLON);
        this.hostname = parts[0];
        this.port = Integer.parseInt(parts[1]);
        this.sslPort = parts.length > 2 ? Integer.parseInt(parts[2]) : -1;
        this.socketAddress = new InetSocketAddress(this.hostname, this.port);
        this.sslSocketAddress = this.sslPort != -1 ? new InetSocketAddress(this.hostname, this.sslPort) : null;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public int getSSLPort() {
        return this.sslPort;
    }

    public InetSocketAddress getSocketAddress() {
        return this.socketAddress;
    }

    public InetSocketAddress getSSLSocketAddress() {
        return this.sslSocketAddress;
    }

    public boolean isSSLEnabled() {
        return this.sslPort != -1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.hostname).append(COLON).append(this.port).append(COLON).append(this.sslPort);
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HedwigSocketAddress)) {
            return false;
        }
        HedwigSocketAddress that = (HedwigSocketAddress)obj;
        return this.hostname.equals(that.hostname) && this.port == that.port && this.sslPort == that.sslPort;
    }

    public int hashCode() {
        return (this.hostname + this.port + this.sslPort).hashCode();
    }

    public static String sockAddrStr(InetSocketAddress addr) {
        return addr.getAddress().getHostAddress() + COLON + addr.getPort();
    }
}

