/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hedwig.util;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    static DirDeleterThred dirDeleterThread;
    static Logger log;

    public static File createTempDirectory(String prefix) throws IOException {
        return FileUtils.createTempDirectory(prefix, null);
    }

    public static File createTempDirectory(String prefix, String suffix) throws IOException {
        File tempDir = File.createTempFile(prefix, suffix);
        if (!tempDir.delete()) {
            throw new IOException("Could not delete temp file: " + tempDir.getAbsolutePath());
        }
        if (!tempDir.mkdir()) {
            throw new IOException("Could not create temp directory: " + tempDir.getAbsolutePath());
        }
        dirDeleterThread.addDirToDelete(tempDir);
        return tempDir;
    }

    static {
        log = LoggerFactory.getLogger(FileUtils.class);
        dirDeleterThread = new DirDeleterThred();
        Runtime.getRuntime().addShutdownHook(dirDeleterThread);
    }

    static class DirDeleterThred
    extends Thread {
        List<File> dirsToDelete = new LinkedList<File>();

        DirDeleterThred() {
        }

        public synchronized void addDirToDelete(File dir) {
            this.dirsToDelete.add(dir);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            DirDeleterThred dirDeleterThred = this;
            synchronized (dirDeleterThred) {
                for (File dir : this.dirsToDelete) {
                    this.deleteDirectory(dir);
                }
            }
        }

        protected void deleteDirectory(File dir) {
            if (dir.isFile()) {
                if (!dir.delete()) {
                    log.error("Could not delete " + dir.getAbsolutePath());
                }
                return;
            }
            File[] files = dir.listFiles();
            if (files == null) {
                return;
            }
            for (File f : files) {
                this.deleteDirectory(f);
            }
            if (!dir.delete()) {
                log.error("Could not delete directory: " + dir.getAbsolutePath());
            }
        }
    }
}

