/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hedwig.client.netty.impl;

import java.net.InetSocketAddress;
import org.apache.hedwig.client.data.PubSubData;
import org.apache.hedwig.client.netty.impl.AbstractHChannelManager;
import org.apache.hedwig.client.netty.impl.ClientChannelPipelineFactory;
import org.apache.hedwig.client.netty.impl.HChannelImpl;
import org.apache.hedwig.protocol.PubSubProtocol;
import org.apache.hedwig.util.VarArgs;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultServerChannel
extends HChannelImpl {
    private static Logger logger = LoggerFactory.getLogger(DefaultServerChannel.class);

    DefaultServerChannel(InetSocketAddress host, AbstractHChannelManager channelManager) {
        super(host, channelManager);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[DefaultServer: ").append(this.host).append("]");
        return sb.toString();
    }

    @Override
    public void submitOp(final PubSubData pubSubData) {
        ClientChannelPipelineFactory pipelineFactory = PubSubProtocol.OperationType.PUBLISH.equals((Object)pubSubData.operationType) || PubSubProtocol.OperationType.UNSUBSCRIBE.equals((Object)pubSubData.operationType) ? this.channelManager.getNonSubscriptionChannelPipelineFactory() : this.channelManager.getSubscriptionChannelPipelineFactory();
        ChannelFuture future = this.connect(this.host, pipelineFactory);
        future.addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (DefaultServerChannel.this.closed) {
                    future.getChannel().close();
                    return;
                }
                if (!future.isSuccess()) {
                    logger.error("Error connecting to host {}.", (Object)DefaultServerChannel.this.host);
                    future.getChannel().close();
                    DefaultServerChannel.this.retryOrFailOp(pubSubData);
                    return;
                }
                logger.debug("Connected to host {} for pubSubData: {}", VarArgs.va(DefaultServerChannel.this.host, pubSubData));
                DefaultServerChannel.this.channelManager.submitOpThruChannel(pubSubData, future.getChannel());
            }
        });
    }
}

