/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hedwig.client.netty;

import com.google.protobuf.ByteString;
import org.apache.hedwig.client.api.MessageHandler;
import org.apache.hedwig.filter.ClientMessageFilter;
import org.apache.hedwig.protocol.PubSubProtocol;
import org.apache.hedwig.util.Callback;

public class FilterableMessageHandler
implements MessageHandler {
    MessageHandler msgHandler;
    ClientMessageFilter msgFilter;

    public FilterableMessageHandler(MessageHandler msgHandler, ClientMessageFilter msgFilter) {
        this.msgHandler = msgHandler;
        this.msgFilter = msgFilter;
    }

    public boolean hasMessageHandler() {
        return null != this.msgHandler;
    }

    public MessageHandler getMessageHandler() {
        return this.msgHandler;
    }

    public boolean hasMessageFilter() {
        return null != this.msgFilter;
    }

    public ClientMessageFilter getMessageFilter() {
        return this.msgFilter;
    }

    @Override
    public void deliver(ByteString topic, ByteString subscriberId, PubSubProtocol.Message msg, Callback<Void> callback, Object context) {
        boolean deliver = true;
        if (this.hasMessageFilter()) {
            deliver = this.msgFilter.testMessage(msg);
        }
        if (deliver) {
            this.msgHandler.deliver(topic, subscriberId, msg, callback, context);
        } else {
            callback.operationFinished(context, null);
        }
    }
}

