/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hedwig.client.netty;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hedwig.client.netty.HChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanupChannelMap<T> {
    private static Logger logger = LoggerFactory.getLogger(CleanupChannelMap.class);
    private final ConcurrentHashMap<T, HChannel> channels;
    protected boolean closed = false;
    protected final ReentrantReadWriteLock closedLock = new ReentrantReadWriteLock();

    public CleanupChannelMap() {
        this.channels = new ConcurrentHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HChannel addChannel(T key, HChannel channel) {
        this.closedLock.readLock().lock();
        try {
            if (this.closed) {
                channel.close();
                HChannel hChannel = channel;
                return hChannel;
            }
            HChannel oldChannel = this.channels.putIfAbsent(key, channel);
            if (null != oldChannel) {
                logger.info("Channel for {} already exists, so no need to store it.", key);
                channel.close();
                HChannel hChannel = oldChannel;
                return hChannel;
            }
            logger.debug("Storing a new channel for {}.", key);
            HChannel hChannel = channel;
            return hChannel;
        }
        finally {
            this.closedLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replaceChannel(T key, HChannel oldChannel, HChannel newChannel) {
        this.closedLock.readLock().lock();
        try {
            if (this.closed) {
                if (null != oldChannel) {
                    oldChannel.close();
                }
                if (null != newChannel) {
                    newChannel.close();
                }
                boolean bl = false;
                return bl;
            }
            if (null == oldChannel) {
                HChannel existedChannel = this.channels.putIfAbsent(key, newChannel);
                if (null != existedChannel) {
                    logger.info("Channel for {} already exists, so no need to replace it.", key);
                    newChannel.close();
                    boolean bl = false;
                    return bl;
                }
                logger.debug("Storing a new channel for {}.", key);
                boolean bl = true;
                return bl;
            }
            if (this.channels.replace(key, oldChannel, newChannel)) {
                logger.debug("Replacd channel {} for {}.", (Object)oldChannel, key);
                oldChannel.close();
                boolean bl = true;
                return bl;
            }
            newChannel.close();
            boolean bl = false;
            return bl;
        }
        finally {
            this.closedLock.readLock().unlock();
        }
    }

    public HChannel getChannel(T key) {
        return this.channels.get(key);
    }

    public HChannel removeChannel(T key) {
        return this.channels.remove(key);
    }

    public boolean removeChannel(T key, HChannel channel) {
        return this.channels.remove(key, channel);
    }

    public Collection<HChannel> getChannels() {
        return this.channels.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.closedLock.writeLock().lock();
        try {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        finally {
            this.closedLock.writeLock().unlock();
        }
        logger.debug("Closing channels map.");
        for (HChannel channel : this.channels.values()) {
            channel.close(true);
        }
        this.channels.clear();
        logger.debug("Closed channels map.");
    }
}

