/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hedwig.client.handlers;

import org.apache.hedwig.client.conf.ClientConfiguration;
import org.apache.hedwig.client.data.PubSubData;
import org.apache.hedwig.client.handlers.AbstractResponseHandler;
import org.apache.hedwig.client.netty.HChannelManager;
import org.apache.hedwig.exceptions.PubSubException;
import org.apache.hedwig.protocol.PubSubProtocol;
import org.jboss.netty.channel.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnsubscribeResponseHandler
extends AbstractResponseHandler {
    private static Logger logger = LoggerFactory.getLogger(UnsubscribeResponseHandler.class);

    public UnsubscribeResponseHandler(ClientConfiguration cfg, HChannelManager channelManager) {
        super(cfg, channelManager);
    }

    @Override
    public void handleResponse(PubSubProtocol.PubSubResponse response, PubSubData pubSubData, Channel channel) throws Exception {
        switch (response.getStatusCode()) {
            case SUCCESS: {
                pubSubData.getCallback().operationFinished(pubSubData.context, null);
                break;
            }
            case CLIENT_NOT_SUBSCRIBED: {
                pubSubData.getCallback().operationFailed(pubSubData.context, (PubSubException)new PubSubException.ClientNotSubscribedException("Client was never subscribed to topic: " + pubSubData.topic.toStringUtf8() + ", subscriberId: " + pubSubData.subscriberId.toStringUtf8()));
                break;
            }
            case SERVICE_DOWN: {
                pubSubData.getCallback().operationFailed(pubSubData.context, (PubSubException)new PubSubException.ServiceDownException("Server responded with a SERVICE_DOWN status"));
                break;
            }
            case NOT_RESPONSIBLE_FOR_TOPIC: {
                this.handleRedirectResponse(response, pubSubData, channel);
                break;
            }
            default: {
                logger.error("Unexpected error response from server for PubSubResponse: " + response);
                pubSubData.getCallback().operationFailed(pubSubData.context, (PubSubException)new PubSubException.ServiceDownException("Server responded with a status code of: " + response.getStatusCode()));
            }
        }
    }
}

