/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hedwig.client.handlers;

import com.google.protobuf.ByteString;
import java.net.InetSocketAddress;
import java.util.LinkedList;
import org.apache.hedwig.client.conf.ClientConfiguration;
import org.apache.hedwig.client.data.PubSubData;
import org.apache.hedwig.client.exceptions.ServerRedirectLoopException;
import org.apache.hedwig.client.exceptions.TooManyServerRedirectsException;
import org.apache.hedwig.client.netty.HChannelManager;
import org.apache.hedwig.client.netty.NetUtils;
import org.apache.hedwig.exceptions.PubSubException;
import org.apache.hedwig.protocol.PubSubProtocol;
import org.apache.hedwig.util.HedwigSocketAddress;
import org.apache.hedwig.util.VarArgs;
import org.jboss.netty.channel.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractResponseHandler {
    private static Logger logger = LoggerFactory.getLogger(AbstractResponseHandler.class);
    protected final ClientConfiguration cfg;
    protected final HChannelManager channelManager;

    protected AbstractResponseHandler(ClientConfiguration cfg, HChannelManager channelManager) {
        this.cfg = cfg;
        this.channelManager = channelManager;
    }

    public abstract void handleResponse(PubSubProtocol.PubSubResponse var1, PubSubData var2, Channel var3) throws Exception;

    protected void handleRedirectResponse(PubSubProtocol.PubSubResponse response, PubSubData pubSubData, Channel channel) throws Exception {
        boolean redirectToDefaultServer;
        InetSocketAddress redirectedHost;
        int curNumServerRedirects;
        if (logger.isDebugEnabled()) {
            logger.debug("Handling a redirect from host: {}, response: {}, pubSubData: {}", VarArgs.va(NetUtils.getHostFromChannel(channel), response, pubSubData));
        }
        int n = curNumServerRedirects = pubSubData.triedServers == null ? 0 : pubSubData.triedServers.size();
        if (curNumServerRedirects >= this.cfg.getMaximumServerRedirects()) {
            logger.debug("Exceeded the number of server redirects ({}) so error out.", (Object)curNumServerRedirects);
            PubSubException.ServiceDownException exception = new PubSubException.ServiceDownException((Exception)new TooManyServerRedirectsException("Already reached max number of redirects: " + curNumServerRedirects));
            pubSubData.getCallback().operationFailed(pubSubData.context, (PubSubException)exception);
            return;
        }
        ByteString triedServer = ByteString.copyFromUtf8((String)HedwigSocketAddress.sockAddrStr(NetUtils.getHostFromChannel(channel)));
        if (pubSubData.triedServers == null) {
            pubSubData.triedServers = new LinkedList<ByteString>();
        }
        pubSubData.shouldClaim = true;
        pubSubData.triedServers.add(triedServer);
        String statusMsg = response.getStatusMsg();
        if (statusMsg != null && statusMsg.length() > 0) {
            redirectedHost = this.cfg.isSSLEnabled() ? new HedwigSocketAddress(statusMsg).getSSLSocketAddress() : new HedwigSocketAddress(statusMsg).getSocketAddress();
            redirectToDefaultServer = false;
        } else {
            redirectedHost = this.cfg.getDefaultServerHost();
            redirectToDefaultServer = true;
        }
        if (pubSubData.triedServers.contains(ByteString.copyFromUtf8((String)HedwigSocketAddress.sockAddrStr(redirectedHost)))) {
            logger.error("We've already sent this PubSubRequest before to redirectedHost: {}, pubSubData: {}", VarArgs.va(redirectedHost, pubSubData));
            PubSubException.ServiceDownException exception = new PubSubException.ServiceDownException((Exception)new ServerRedirectLoopException("Already made the request before to redirected host: " + redirectedHost));
            pubSubData.getCallback().operationFailed(pubSubData.context, (PubSubException)exception);
            return;
        }
        if (redirectToDefaultServer) {
            this.channelManager.submitOpToDefaultServer(pubSubData);
        } else {
            this.channelManager.redirectToHost(pubSubData, redirectedHost);
        }
    }
}

