/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hedwig.filter;

import com.google.protobuf.ByteString;
import java.io.IOException;
import java.util.LinkedList;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.hedwig.filter.MessageFilterBase;
import org.apache.hedwig.filter.ServerMessageFilter;
import org.apache.hedwig.protocol.PubSubProtocol;

public class PipelineFilter
extends LinkedList<ServerMessageFilter>
implements ServerMessageFilter {
    @Override
    public ServerMessageFilter initialize(Configuration conf) throws ConfigurationException, IOException {
        for (ServerMessageFilter filter : this) {
            filter.initialize(conf);
        }
        return this;
    }

    @Override
    public void uninitialize() {
        while (!this.isEmpty()) {
            ServerMessageFilter filter = (ServerMessageFilter)this.removeLast();
            filter.uninitialize();
        }
    }

    @Override
    public MessageFilterBase setSubscriptionPreferences(ByteString topic, ByteString subscriberId, PubSubProtocol.SubscriptionPreferences preferences) {
        for (ServerMessageFilter filter : this) {
            filter.setSubscriptionPreferences(topic, subscriberId, preferences);
        }
        return this;
    }

    @Override
    public boolean testMessage(PubSubProtocol.Message message) {
        for (ServerMessageFilter filter : this) {
            if (filter.testMessage(message)) continue;
            return false;
        }
        return true;
    }
}

