/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hedwig.client.netty.impl.multiplex;

import java.net.InetSocketAddress;
import org.apache.hedwig.client.conf.ClientConfiguration;
import org.apache.hedwig.client.data.PubSubData;
import org.apache.hedwig.client.data.TopicSubscriber;
import org.apache.hedwig.client.netty.HChannel;
import org.apache.hedwig.client.netty.HChannelManager;
import org.apache.hedwig.client.netty.NetUtils;
import org.apache.hedwig.client.netty.impl.AbstractSubscribeResponseHandler;
import org.apache.hedwig.client.netty.impl.ActiveSubscriber;
import org.apache.hedwig.client.netty.impl.multiplex.MultiplexHChannelManager;
import org.apache.hedwig.exceptions.PubSubException;
import org.apache.hedwig.protocol.PubSubProtocol;
import org.apache.hedwig.util.Callback;
import org.apache.hedwig.util.Either;
import org.apache.hedwig.util.VarArgs;
import org.jboss.netty.channel.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiplexSubscribeResponseHandler
extends AbstractSubscribeResponseHandler {
    private static Logger logger = LoggerFactory.getLogger(MultiplexSubscribeResponseHandler.class);
    volatile HChannel hChannel;
    private final MultiplexHChannelManager sChannelManager;

    protected MultiplexSubscribeResponseHandler(ClientConfiguration cfg, HChannelManager channelManager) {
        super(cfg, channelManager);
        this.sChannelManager = (MultiplexHChannelManager)channelManager;
    }

    @Override
    public void handleResponse(PubSubProtocol.PubSubResponse response, PubSubData pubSubData, Channel channel) throws Exception {
        if (null == this.hChannel) {
            InetSocketAddress host = NetUtils.getHostFromChannel(channel);
            this.hChannel = this.sChannelManager.getSubscriptionChannel(host);
            if (null == this.hChannel || !channel.equals(this.hChannel.getChannel())) {
                PubSubException.UnexpectedConditionException pse = new PubSubException.UnexpectedConditionException("Failed to get subscription channel of " + host);
                pubSubData.getCallback().operationFailed(pubSubData.context, (PubSubException)pse);
                return;
            }
        }
        super.handleResponse(response, pubSubData, channel);
    }

    @Override
    protected Either<PubSubProtocol.StatusCode, HChannel> handleSuccessResponse(TopicSubscriber ts, PubSubData pubSubData, Channel channel) {
        Either<Boolean, HChannel> result = this.sChannelManager.storeSubscriptionChannel(ts, pubSubData, this.hChannel);
        if (result.left().booleanValue()) {
            return Either.of(PubSubProtocol.StatusCode.SUCCESS, result.right());
        }
        PubSubProtocol.StatusCode code = pubSubData.isResubscribeRequest() ? PubSubProtocol.StatusCode.RESUBSCRIBE_EXCEPTION : PubSubProtocol.StatusCode.CLIENT_ALREADY_SUBSCRIBED;
        return Either.of(code, null);
    }

    @Override
    public void asyncCloseSubscription(final TopicSubscriber topicSubscriber, final Callback<PubSubProtocol.ResponseBody> callback, final Object context) {
        final ActiveSubscriber ss = this.getActiveSubscriber(topicSubscriber);
        if (null == ss || null == this.hChannel) {
            logger.debug("No subscription {} found when closing its subscription from {}.", VarArgs.va(topicSubscriber, this.hChannel));
            callback.operationFinished(context, null);
            return;
        }
        Callback<PubSubProtocol.ResponseBody> closeCb = new Callback<PubSubProtocol.ResponseBody>(){

            @Override
            public void operationFinished(Object ctx, PubSubProtocol.ResponseBody respBody) {
                MultiplexSubscribeResponseHandler.this.removeSubscription(topicSubscriber, ss);
                MultiplexSubscribeResponseHandler.this.sChannelManager.removeSubscriptionChannel(topicSubscriber, MultiplexSubscribeResponseHandler.this.hChannel);
                callback.operationFinished(context, null);
            }

            @Override
            public void operationFailed(Object ctx, PubSubException exception) {
                callback.operationFailed(context, exception);
            }
        };
        PubSubData closeOp = new PubSubData(topicSubscriber.getTopic(), null, topicSubscriber.getSubscriberId(), PubSubProtocol.OperationType.CLOSESUBSCRIPTION, null, closeCb, context);
        this.hChannel.submitOp(closeOp);
    }
}

