/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hedwig.client.netty.impl;

import com.google.protobuf.ByteString;
import java.net.InetSocketAddress;
import java.util.LinkedList;
import org.apache.hedwig.client.data.PubSubData;
import org.apache.hedwig.client.exceptions.NoResponseHandlerException;
import org.apache.hedwig.client.netty.HChannelManager;
import org.apache.hedwig.client.netty.NetUtils;
import org.apache.hedwig.client.netty.impl.HChannelHandler;
import org.apache.hedwig.client.netty.impl.HChannelImpl;
import org.apache.hedwig.exceptions.PubSubException;
import org.apache.hedwig.util.HedwigSocketAddress;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteCallback
implements ChannelFutureListener {
    private static Logger logger = LoggerFactory.getLogger(WriteCallback.class);
    private PubSubData pubSubData;
    private final HChannelManager channelManager;

    public WriteCallback(PubSubData pubSubData, HChannelManager channelManager) {
        this.pubSubData = pubSubData;
        this.channelManager = channelManager;
    }

    public void operationComplete(ChannelFuture future) throws Exception {
        if (this.channelManager.isClosed()) {
            future.getChannel().close();
            return;
        }
        InetSocketAddress host = NetUtils.getHostFromChannel(future.getChannel());
        if (!future.isSuccess()) {
            ByteString hostString;
            logger.error("Error writing on channel to host: {}", (Object)host);
            try {
                HChannelHandler channelHandler = HChannelImpl.getHChannelHandlerFromChannel(future.getChannel());
                channelHandler.removeTxn(this.pubSubData.txnId);
                channelHandler.closeExplicitly();
            }
            catch (NoResponseHandlerException e) {
                logger.warn("Could not find response handler to remove txnId mapping to pubsub data. Ignoring.");
            }
            future.getChannel().close();
            ByteString byteString = hostString = host == null ? null : ByteString.copyFromUtf8((String)HedwigSocketAddress.sockAddrStr(host));
            if (this.pubSubData.writeFailedServers != null && this.pubSubData.writeFailedServers.contains(hostString)) {
                logger.error("Error writing to host more than once so just invoke the operationFailed callback!");
                this.pubSubData.getCallback().operationFailed(this.pubSubData.context, (PubSubException)new PubSubException.ServiceDownException("Error while writing message to server: " + hostString));
            } else {
                logger.debug("Try to send the PubSubRequest again to the default server host/VIP for pubSubData: {}", (Object)this.pubSubData);
                if (this.pubSubData.writeFailedServers == null) {
                    this.pubSubData.writeFailedServers = new LinkedList<ByteString>();
                }
                this.pubSubData.writeFailedServers.add(hostString);
                this.channelManager.submitOpToDefaultServer(this.pubSubData);
            }
        } else {
            logger.debug("Successfully wrote to host: {} for pubSubData: {}", (Object)host, (Object)this.pubSubData);
        }
    }
}

