/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hedwig.client.netty.impl;

import org.apache.hedwig.client.data.PubSubData;
import org.apache.hedwig.client.data.TopicSubscriber;
import org.apache.hedwig.client.exceptions.AlreadyStartDeliveryException;
import org.apache.hedwig.client.netty.impl.AbstractHChannelManager;
import org.apache.hedwig.exceptions.PubSubException;
import org.apache.hedwig.protocol.PubSubProtocol;
import org.apache.hedwig.util.Callback;
import org.apache.hedwig.util.VarArgs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ResubscribeCallback
implements Callback<PubSubProtocol.ResponseBody> {
    private static Logger logger = LoggerFactory.getLogger(ResubscribeCallback.class);
    private final TopicSubscriber origTopicSubscriber;
    private final PubSubData origSubData;
    private final AbstractHChannelManager channelManager;
    private final long retryWaitTime;

    ResubscribeCallback(TopicSubscriber origTopicSubscriber, PubSubData origSubData, AbstractHChannelManager channelManager, long retryWaitTime) {
        this.origTopicSubscriber = origTopicSubscriber;
        this.origSubData = origSubData;
        this.channelManager = channelManager;
        this.retryWaitTime = retryWaitTime;
    }

    @Override
    public void operationFinished(Object ctx, PubSubProtocol.ResponseBody resultOfOperation) {
        if (logger.isDebugEnabled()) {
            logger.debug("Resubscribe succeeded for origSubData: " + this.origSubData);
        }
        try {
            this.channelManager.restartDelivery(this.origTopicSubscriber);
        }
        catch (PubSubException.ClientNotSubscribedException e) {
            logger.error("Subscribe was successful but error starting delivery for {} : {}", VarArgs.va(this.origTopicSubscriber, e.getMessage()));
            this.retrySubscribeRequest();
        }
        catch (AlreadyStartDeliveryException alreadyStartDeliveryException) {
            // empty catch block
        }
    }

    @Override
    public void operationFailed(Object ctx, PubSubException exception) {
        if (exception instanceof PubSubException.ResubscribeException) {
            logger.warn("Failed to resubscribe {} : but it is caused by closesub when resubscribing. so we don't need to retry subscribe again.", (Object)this.origSubData);
        }
        logger.error("Resubscribe failed with error: " + exception.getMessage());
        if (!this.channelManager.isClosed()) {
            this.retrySubscribeRequest();
        }
    }

    private void retrySubscribeRequest() {
        if (this.channelManager.isClosed()) {
            return;
        }
        this.origSubData.clearServersList();
        logger.debug("Resubmit subscribe request for {} in {} ms later.", VarArgs.va(this.origTopicSubscriber, this.retryWaitTime));
        this.channelManager.submitOpAfterDelay(this.origSubData, this.retryWaitTime);
    }
}

