/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hedwig.client.netty.impl;

import com.google.protobuf.MessageLite;
import java.util.Map;
import org.apache.hedwig.client.conf.ClientConfiguration;
import org.apache.hedwig.client.handlers.AbstractResponseHandler;
import org.apache.hedwig.client.netty.impl.AbstractHChannelManager;
import org.apache.hedwig.client.netty.impl.HChannelHandler;
import org.apache.hedwig.protocol.PubSubProtocol;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.codec.frame.LengthFieldBasedFrameDecoder;
import org.jboss.netty.handler.codec.frame.LengthFieldPrepender;
import org.jboss.netty.handler.codec.protobuf.ProtobufDecoder;
import org.jboss.netty.handler.codec.protobuf.ProtobufEncoder;
import org.jboss.netty.handler.ssl.SslHandler;

public abstract class ClientChannelPipelineFactory
implements ChannelPipelineFactory {
    protected ClientConfiguration cfg;
    protected AbstractHChannelManager channelManager;

    public ClientChannelPipelineFactory(ClientConfiguration cfg, AbstractHChannelManager channelManager) {
        this.cfg = cfg;
        this.channelManager = channelManager;
    }

    protected abstract Map<PubSubProtocol.OperationType, AbstractResponseHandler> createResponseHandlers();

    private HChannelHandler createHChannelHandler() {
        return new HChannelHandler(this.cfg, this.channelManager, this.createResponseHandlers());
    }

    public ChannelPipeline getPipeline() throws Exception {
        ChannelPipeline pipeline = Channels.pipeline();
        if (this.channelManager.getSslFactory() != null) {
            pipeline.addLast("ssl", (ChannelHandler)new SslHandler(this.channelManager.getSslFactory().getEngine()));
        }
        pipeline.addLast("lengthbaseddecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(this.cfg.getMaximumMessageSize(), 0, 4, 0, 4));
        pipeline.addLast("lengthprepender", (ChannelHandler)new LengthFieldPrepender(4));
        pipeline.addLast("protobufdecoder", (ChannelHandler)new ProtobufDecoder((MessageLite)PubSubProtocol.PubSubResponse.getDefaultInstance()));
        pipeline.addLast("protobufencoder", (ChannelHandler)new ProtobufEncoder());
        pipeline.addLast("responsehandler", (ChannelHandler)this.createHChannelHandler());
        return pipeline;
    }
}

