/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hedwig.client.conf;

import java.net.InetSocketAddress;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.hedwig.conf.AbstractConfiguration;
import org.apache.hedwig.util.HedwigSocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientConfiguration
extends AbstractConfiguration {
    Logger logger = LoggerFactory.getLogger(ClientConfiguration.class);
    protected static final String DEFAULT_SERVER_HOST = "default_server_host";
    protected static final String MAX_MESSAGE_SIZE = "max_message_size";
    protected static final String MAX_SERVER_REDIRECTS = "max_server_redirects";
    protected static final String AUTO_SEND_CONSUME_MESSAGE_ENABLED = "auto_send_consume_message_enabled";
    protected static final String CONSUMED_MESSAGES_BUFFER_SIZE = "consumed_messages_buffer_size";
    protected static final String MESSAGE_CONSUME_RETRY_WAIT_TIME = "message_consume_retry_wait_time";
    protected static final String SUBSCRIBE_RECONNECT_RETRY_WAIT_TIME = "subscribe_reconnect_retry_wait_time";
    protected static final String MAX_OUTSTANDING_MESSAGES = "max_outstanding_messages";
    protected static final String SERVER_ACK_RESPONSE_TIMEOUT = "server_ack_response_timeout";
    protected static final String TIMEOUT_THREAD_RUN_INTERVAL = "timeout_thread_run_interval";
    protected static final String SSL_ENABLED = "ssl_enabled";
    protected static final String SUBSCRIPTION_MESSAGE_BOUND = "subscription_message_bound";
    protected static final String SUBSCRIPTION_CHANNEL_SHARING_ENABLED = "subscription_channel_sharing_enabled";
    protected HedwigSocketAddress myDefaultServerAddress = null;

    protected HedwigSocketAddress getDefaultServerHedwigSocketAddress() {
        if (this.myDefaultServerAddress == null) {
            this.myDefaultServerAddress = new HedwigSocketAddress(this.conf.getString(DEFAULT_SERVER_HOST, "localhost:4080:9876"));
        }
        return this.myDefaultServerAddress;
    }

    public InetSocketAddress getDefaultServerHost() {
        if (this.isSSLEnabled()) {
            return this.getDefaultServerHedwigSocketAddress().getSSLSocketAddress();
        }
        return this.getDefaultServerHedwigSocketAddress().getSocketAddress();
    }

    public int getMaximumMessageSize() {
        return this.conf.getInt(MAX_MESSAGE_SIZE, 0x200000);
    }

    public int getMaximumServerRedirects() {
        return this.conf.getInt(MAX_SERVER_REDIRECTS, 2);
    }

    public boolean isAutoSendConsumeMessageEnabled() {
        return this.conf.getBoolean(AUTO_SEND_CONSUME_MESSAGE_ENABLED, true);
    }

    public int getConsumedMessagesBufferSize() {
        return this.conf.getInt(CONSUMED_MESSAGES_BUFFER_SIZE, 5);
    }

    public long getMessageConsumeRetryWaitTime() {
        return this.conf.getLong(MESSAGE_CONSUME_RETRY_WAIT_TIME, 10000L);
    }

    public long getSubscribeReconnectRetryWaitTime() {
        return this.conf.getLong(SUBSCRIBE_RECONNECT_RETRY_WAIT_TIME, 10000L);
    }

    public int getMaximumOutstandingMessages() {
        return this.conf.getInt(MAX_OUTSTANDING_MESSAGES, 10);
    }

    public long getServerAckResponseTimeout() {
        return this.conf.getLong(SERVER_ACK_RESPONSE_TIMEOUT, 30000L);
    }

    public long getTimeoutThreadRunInterval() {
        return this.conf.getLong(TIMEOUT_THREAD_RUN_INTERVAL, 60000L);
    }

    public boolean isSSLEnabled() {
        return this.conf.getBoolean(SSL_ENABLED, false);
    }

    public boolean isSubscriptionChannelSharingEnabled() {
        return this.conf.getBoolean(SUBSCRIPTION_CHANNEL_SHARING_ENABLED, false);
    }

    public int getSubscriptionMessageBound() {
        return this.conf.getInt(SUBSCRIPTION_MESSAGE_BOUND, 0);
    }

    public void validate() throws ConfigurationException {
        if (this.isSSLEnabled() && this.getDefaultServerHedwigSocketAddress().getSSLSocketAddress() == null) {
            throw new ConfigurationException("SSL is enabled but a default server SSL port not given!");
        }
    }
}

