/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hedwig.client.benchmark;

import com.google.protobuf.ByteString;
import java.util.HashMap;
import java.util.concurrent.Callable;
import org.apache.bookkeeper.util.MathUtils;
import org.apache.hedwig.client.api.MessageHandler;
import org.apache.hedwig.client.api.Subscriber;
import org.apache.hedwig.client.benchmark.BenchmarkUtils;
import org.apache.hedwig.client.benchmark.BenchmarkWorker;
import org.apache.hedwig.client.benchmark.HedwigBenchmark;
import org.apache.hedwig.protocol.PubSubProtocol;
import org.apache.hedwig.util.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BenchmarkSubscriber
extends BenchmarkWorker
implements Callable<Void> {
    static final Logger logger = LoggerFactory.getLogger(BenchmarkSubscriber.class);
    Subscriber subscriber;
    ByteString subId;

    public BenchmarkSubscriber(int numTopics, int numMessages, int numRegions, int startTopicLabel, int partitionIndex, int numPartitions, Subscriber subscriber, ByteString subId) {
        super(numTopics, numMessages, numRegions, startTopicLabel, partitionIndex, numPartitions);
        this.subscriber = subscriber;
        this.subId = subId;
    }

    public void warmup(int numWarmup) throws InterruptedException {
        this.multiSub("warmup", "warmup", 0, numWarmup, numWarmup * this.numPartitions);
    }

    @Override
    public Void call() throws Exception {
        final BenchmarkUtils.ThroughputAggregator agg = new BenchmarkUtils.ThroughputAggregator("recvs", this.numMessages);
        agg.startProgress();
        final HashMap lastSeqIdSeenMap = new HashMap();
        for (int i = this.startTopicLabel; i < this.startTopicLabel + this.numTopics; ++i) {
            if (!HedwigBenchmark.amIResponsibleForTopic(i, this.partitionIndex, this.numPartitions)) continue;
            final String topic = "topic" + i;
            this.subscriber.subscribe(ByteString.copyFromUtf8((String)topic), this.subId, PubSubProtocol.SubscribeRequest.CreateOrAttach.CREATE_OR_ATTACH);
            this.subscriber.startDelivery(ByteString.copyFromUtf8((String)topic), this.subId, new MessageHandler(){

                @Override
                public void deliver(ByteString thisTopic, ByteString subscriberId, PubSubProtocol.Message msg, Callback<Void> callback, Object context) {
                    logger.debug("Got message from src-region: {} with seq-id: {}", (Object)msg.getSrcRegion(), (Object)msg.getMsgId());
                    String mapKey = topic + msg.getSrcRegion().toStringUtf8();
                    Long lastSeqIdSeen = (Long)lastSeqIdSeenMap.get(mapKey);
                    if (lastSeqIdSeen == null) {
                        lastSeqIdSeen = 0L;
                    }
                    if (BenchmarkSubscriber.this.getSrcSeqId(msg) <= lastSeqIdSeen) {
                        logger.info("Redelivery of message, src-region: " + msg.getSrcRegion() + "seq-id: " + msg.getMsgId());
                    } else {
                        agg.ding(false);
                    }
                    callback.operationFinished(context, null);
                }
            });
        }
        System.out.println("Finished subscribing to topics and now waiting for messages to come in...");
        agg.queue.take();
        System.out.println(agg.summarize(agg.earliest.get()));
        return null;
    }

    long getSrcSeqId(PubSubProtocol.Message msg) {
        if (msg.getMsgId().getRemoteComponentsCount() == 0) {
            return msg.getMsgId().getLocalComponent();
        }
        for (PubSubProtocol.RegionSpecificSeqId rseqId : msg.getMsgId().getRemoteComponentsList()) {
            if (!rseqId.getRegion().equals((Object)msg.getSrcRegion())) continue;
            return rseqId.getSeqId();
        }
        return msg.getMsgId().getLocalComponent();
    }

    void multiSub(String label, String topicPrefix, int start, int npar, int count) throws InterruptedException {
        long startTime = MathUtils.now();
        BenchmarkUtils.ThroughputLatencyAggregator agg = new BenchmarkUtils.ThroughputLatencyAggregator(label, count / this.numPartitions, npar);
        agg.startProgress();
        int end = start + count;
        for (int i = start; i < end; ++i) {
            if (!HedwigBenchmark.amIResponsibleForTopic(i, this.partitionIndex, this.numPartitions)) continue;
            this.subscriber.asyncSubscribe(ByteString.copyFromUtf8((String)(topicPrefix + i)), this.subId, PubSubProtocol.SubscribeRequest.CreateOrAttach.CREATE_OR_ATTACH, (Callback<Void>)new BenchmarkUtils.BenchmarkCallback(agg), null);
        }
        agg.tpAgg.queue.take();
        if (count > 1) {
            System.out.println(agg.summarize(startTime));
        }
    }
}

