/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hedwig.client.benchmark;

import com.google.protobuf.ByteString;
import java.util.concurrent.Callable;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.hedwig.client.HedwigClient;
import org.apache.hedwig.client.api.Publisher;
import org.apache.hedwig.client.api.Subscriber;
import org.apache.hedwig.client.benchmark.BenchmarkPublisher;
import org.apache.hedwig.client.benchmark.BenchmarkSubscriber;
import org.apache.hedwig.client.conf.ClientConfiguration;
import org.apache.hedwig.util.HedwigSocketAddress;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.jboss.netty.logging.Log4JLoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HedwigBenchmark
implements Callable<Void> {
    protected static final Logger logger = LoggerFactory.getLogger(HedwigBenchmark.class);
    static final String TOPIC_PREFIX = "topic";
    private final HedwigClient client;
    private final Publisher publisher;
    private final Subscriber subscriber;
    private final CommandLine cmd;

    public HedwigBenchmark(ClientConfiguration cfg, CommandLine cmd) {
        this.client = new HedwigClient(cfg);
        this.publisher = this.client.getPublisher();
        this.subscriber = this.client.getSubscriber();
        this.cmd = cmd;
    }

    static boolean amIResponsibleForTopic(int topicNum, int partitionIndex, int numPartitions) {
        return topicNum % numPartitions == partitionIndex;
    }

    @Override
    public Void call() throws Exception {
        String mode = this.cmd.getOptionValue("mode", "");
        int numTopics = Integer.valueOf(this.cmd.getOptionValue("nTopics", "50"));
        int numMessages = Integer.valueOf(this.cmd.getOptionValue("nMsgs", "1000"));
        int numRegions = Integer.valueOf(this.cmd.getOptionValue("nRegions", "1"));
        int startTopicLabel = Integer.valueOf(this.cmd.getOptionValue("startTopicLabel", "0"));
        int partitionIndex = Integer.valueOf(this.cmd.getOptionValue("partitionIndex", "0"));
        int numPartitions = Integer.valueOf(this.cmd.getOptionValue("nPartitions", "1"));
        int replicaIndex = Integer.valueOf(this.cmd.getOptionValue("replicaIndex", "0"));
        int rate = Integer.valueOf(this.cmd.getOptionValue("rate", "0"));
        int nParallel = Integer.valueOf(this.cmd.getOptionValue("npar", "100"));
        int msgSize = Integer.valueOf(this.cmd.getOptionValue("msgSize", "1024"));
        int nWarmups = Integer.valueOf(this.cmd.getOptionValue("nwarmups", "1000"));
        if (mode.equals("sub")) {
            BenchmarkSubscriber benchmarkSub = new BenchmarkSubscriber(numTopics, 0, 1, startTopicLabel, 0, 1, this.subscriber, ByteString.copyFromUtf8((String)"mySub"));
            benchmarkSub.warmup(nWarmups);
            benchmarkSub.call();
        } else if (mode.equals("recv")) {
            BenchmarkSubscriber benchmarkSub = new BenchmarkSubscriber(numTopics, numMessages, numRegions, startTopicLabel, partitionIndex, numPartitions, this.subscriber, ByteString.copyFromUtf8((String)("sub-" + replicaIndex)));
            benchmarkSub.call();
        } else if (mode.equals("pub")) {
            BenchmarkPublisher benchmarkPub = new BenchmarkPublisher(numTopics, numMessages, numRegions, startTopicLabel, partitionIndex, numPartitions, this.publisher, this.subscriber, msgSize, nParallel, rate);
            benchmarkPub.warmup(nWarmups);
            benchmarkPub.call();
        } else {
            throw new Exception("unknown mode: " + mode);
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        Options options = new Options();
        options.addOption("mode", true, "sub, recv, or pub");
        options.addOption("nTopics", true, "Number of topics, default 50");
        options.addOption("nMsgs", true, "Number of messages, default 1000");
        options.addOption("nRegions", true, "Number of regsions, default 1");
        options.addOption("startTopicLabel", true, "Prefix of topic labels. Must be numeric. Default 0");
        options.addOption("partitionIndex", true, "If partitioning, the partition index for this client");
        options.addOption("nPartitions", true, "Number of partitions, default 1");
        options.addOption("replicaIndex", true, "default 0");
        options.addOption("rate", true, "default 0");
        options.addOption("npar", true, "default 100");
        options.addOption("msgSize", true, "Size of messages, default 1024");
        options.addOption("nwarmups", true, "Number of warmup messages, default 1000");
        options.addOption("defaultHub", true, "Default hedwig hub to connect to, default localhost:4080");
        PosixParser parser = new PosixParser();
        final CommandLine cmd = parser.parse(options, args);
        if (cmd.hasOption("help")) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("HedwigBenchmark <options>", options);
            System.exit(-1);
        }
        ClientConfiguration cfg = new ClientConfiguration(){

            @Override
            public HedwigSocketAddress getDefaultServerHedwigSocketAddress() {
                return new HedwigSocketAddress(cmd.getOptionValue("defaultHub", "localhost:4080"));
            }

            @Override
            public boolean isSSLEnabled() {
                return false;
            }
        };
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)new Log4JLoggerFactory());
        HedwigBenchmark app = new HedwigBenchmark(cfg, cmd);
        app.call();
        System.exit(0);
    }
}

