/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hedwig.client.benchmark;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.bookkeeper.util.MathUtils;
import org.apache.hedwig.exceptions.PubSubException;
import org.apache.hedwig.util.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BenchmarkUtils {
    static final Logger logger = LoggerFactory.getLogger(BenchmarkUtils.class);

    public static double calcTp(int count, long startTime) {
        return 1000.0 * (double)count / (double)(MathUtils.now() - startTime);
    }

    public static class BenchmarkCallback
    implements Callback<Void> {
        final ThroughputLatencyAggregator agg;
        final long startTime;

        public BenchmarkCallback(ThroughputLatencyAggregator agg) throws InterruptedException {
            this.agg = agg;
            agg.outstanding.acquire();
            this.startTime = MathUtils.now();
        }

        private void finish(boolean failed) {
            this.agg.reportLatency(MathUtils.now() - this.startTime);
            this.agg.tpAgg.ding(failed);
            this.agg.outstanding.release();
        }

        @Override
        public void operationFinished(Object ctx, Void resultOfOperation) {
            this.finish(false);
        }

        @Override
        public void operationFailed(Object ctx, PubSubException exception) {
            this.finish(true);
        }
    }

    public static class ThroughputAggregator {
        final String label;
        final int count;
        final AtomicInteger done = new AtomicInteger();
        final AtomicLong earliest = new AtomicLong();
        final AtomicInteger numFailed = new AtomicInteger();
        final Thread progressThread;
        final LinkedBlockingQueue<Integer> queue = new LinkedBlockingQueue();

        public ThroughputAggregator(final String label, final int count) {
            this.label = label;
            this.count = count;
            if (count == 0) {
                this.queue.add(0);
            }
            this.progressThread = Boolean.getBoolean("progress") ? new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        int doneSnap = 0;
                        int prev = 0;
                        while (doneSnap < count) {
                            if (doneSnap > prev) {
                                System.out.println(label + " progress: " + doneSnap + " of " + count);
                            }
                            Thread.sleep(1000L);
                            prev = doneSnap;
                            doneSnap = ThroughputAggregator.this.done.get();
                        }
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                }
            }) : null;
        }

        public void startProgress() {
            if (this.progressThread != null) {
                this.progressThread.start();
            }
        }

        public void ding(boolean failed) {
            int snapDone = this.done.incrementAndGet();
            this.earliest.compareAndSet(0L, MathUtils.now());
            if (failed) {
                this.numFailed.incrementAndGet();
            }
            if (logger.isDebugEnabled()) {
                logger.debug(this.label + " " + (failed ? "failed" : "succeeded") + ", done so far = " + snapDone);
            }
            if (snapDone == this.count) {
                this.queue.add(this.numFailed.get());
            }
        }

        public String summarize(long startTime) {
            return "Finished " + this.label + ": count = " + this.done.get() + ", tput = " + BenchmarkUtils.calcTp(this.count, startTime) + " ops/s, numFailed = " + this.numFailed;
        }
    }

    public static class ThroughputLatencyAggregator {
        int numBuckets;
        final ThroughputAggregator tpAgg;
        final Semaphore outstanding;
        final AtomicLong sum = new AtomicLong();
        final AtomicLong[] latencyBuckets;

        public ThroughputLatencyAggregator(String label, int count, int limit) throws InterruptedException {
            this.numBuckets = Integer.getInteger("numBuckets", 101);
            this.latencyBuckets = new AtomicLong[this.numBuckets];
            this.tpAgg = new ThroughputAggregator(label, count);
            this.outstanding = new Semaphore(limit);
            for (int i = 0; i < this.numBuckets; ++i) {
                this.latencyBuckets[i] = new AtomicLong();
            }
        }

        public void startProgress() {
            this.tpAgg.startProgress();
        }

        public void reportLatency(long latency) {
            this.sum.addAndGet(latency);
            int bucketIndex = latency >= (long)this.numBuckets ? this.numBuckets - 1 : (int)latency;
            this.latencyBuckets[bucketIndex].incrementAndGet();
        }

        private String getPercentile(double percentile) {
            int numInliersNeeded = (int)(percentile / 100.0 * (double)this.tpAgg.count);
            int numInliersFound = 0;
            for (int i = 0; i < this.numBuckets - 1; ++i) {
                if ((numInliersFound += this.latencyBuckets[i].intValue()) <= numInliersNeeded) continue;
                return i + "";
            }
            return " >= " + (this.numBuckets - 1);
        }

        public String summarize(long startTime) {
            double percentile = Double.parseDouble(System.getProperty("percentile", "99.9"));
            return this.tpAgg.summarize(startTime) + ", avg latency = " + this.sum.get() / (long)this.tpAgg.count + ", " + percentile + "%ile latency = " + this.getPercentile(percentile);
        }
    }
}

