/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hedwig.client.netty;

import com.google.protobuf.ByteString;
import java.net.InetSocketAddress;
import java.util.LinkedList;
import org.apache.hedwig.client.conf.ClientConfiguration;
import org.apache.hedwig.client.data.PubSubData;
import org.apache.hedwig.client.netty.HedwigClientImpl;
import org.apache.hedwig.exceptions.PubSubException;
import org.apache.hedwig.util.HedwigSocketAddress;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteCallback
implements ChannelFutureListener {
    private static Logger logger = LoggerFactory.getLogger(WriteCallback.class);
    private PubSubData pubSubData;
    private final HedwigClientImpl client;
    private final ClientConfiguration cfg;

    public WriteCallback(PubSubData pubSubData, HedwigClientImpl client) {
        this.pubSubData = pubSubData;
        this.client = client;
        this.cfg = client.getConfiguration();
    }

    public void operationComplete(ChannelFuture future) throws Exception {
        if (this.client.hasStopped()) {
            future.getChannel().close();
            return;
        }
        InetSocketAddress host = HedwigClientImpl.getHostFromChannel(future.getChannel());
        if (!future.isSuccess()) {
            ByteString hostString;
            logger.error("Error writing on channel to host: " + host);
            HedwigClientImpl.getResponseHandlerFromChannel((Channel)future.getChannel()).txn2PubSubData.remove(this.pubSubData.txnId);
            future.getChannel().close();
            ByteString byteString = hostString = host == null ? null : ByteString.copyFromUtf8((String)HedwigSocketAddress.sockAddrStr(host));
            if (this.pubSubData.writeFailedServers != null && this.pubSubData.writeFailedServers.contains(hostString)) {
                logger.error("Error writing to host more than once so just invoke the operationFailed callback!");
                this.pubSubData.callback.operationFailed(this.pubSubData.context, (PubSubException)new PubSubException.ServiceDownException("Error while writing message to server: " + hostString));
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("Try to send the PubSubRequest again to the default server host/VIP for pubSubData: " + this.pubSubData);
                }
                if (this.pubSubData.writeFailedServers == null) {
                    this.pubSubData.writeFailedServers = new LinkedList<ByteString>();
                }
                this.pubSubData.writeFailedServers.add(hostString);
                this.client.doConnect(this.pubSubData, this.cfg.getDefaultServerHost());
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("Successfully wrote to host: " + host + " for pubSubData: " + this.pubSubData);
        }
    }
}

