/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hedwig.client.netty;

import com.google.protobuf.ByteString;
import java.net.InetSocketAddress;
import java.util.LinkedList;
import org.apache.hedwig.client.conf.ClientConfiguration;
import org.apache.hedwig.client.data.PubSubData;
import org.apache.hedwig.client.netty.HedwigClientImpl;
import org.apache.hedwig.client.netty.HedwigPublisher;
import org.apache.hedwig.client.netty.HedwigSubscriber;
import org.apache.hedwig.exceptions.PubSubException;
import org.apache.hedwig.protocol.PubSubProtocol;
import org.apache.hedwig.util.HedwigSocketAddress;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectCallback
implements ChannelFutureListener {
    private static Logger logger = LoggerFactory.getLogger(ConnectCallback.class);
    private PubSubData pubSubData;
    private InetSocketAddress host;
    private final HedwigClientImpl client;
    private final HedwigPublisher pub;
    private final HedwigSubscriber sub;
    private final ClientConfiguration cfg;

    public ConnectCallback(PubSubData pubSubData, InetSocketAddress host, HedwigClientImpl client) {
        this.pubSubData = pubSubData;
        this.host = host;
        this.client = client;
        this.pub = client.getPublisher();
        this.sub = client.getSubscriber();
        this.cfg = client.getConfiguration();
    }

    public void operationComplete(ChannelFuture future) throws Exception {
        if (this.client.hasStopped()) {
            future.getChannel().close();
            return;
        }
        if (!future.isSuccess()) {
            logger.error("Error connecting to host: " + this.host);
            future.getChannel().close();
            ByteString hostString = ByteString.copyFromUtf8((String)HedwigSocketAddress.sockAddrStr(this.host));
            if (this.pubSubData.connectFailedServers != null && this.pubSubData.connectFailedServers.contains(hostString)) {
                logger.error("Error connecting to host more than once so just invoke the operationFailed callback!");
                this.pubSubData.callback.operationFailed(this.pubSubData.context, (PubSubException)new PubSubException.CouldNotConnectException("Could not connect to host: " + this.host));
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("Try to connect to server: " + this.host + " again for pubSubData: " + this.pubSubData);
                }
                if (this.pubSubData.connectFailedServers == null) {
                    this.pubSubData.connectFailedServers = new LinkedList<ByteString>();
                }
                this.pubSubData.connectFailedServers.add(hostString);
                this.client.doConnect(this.pubSubData, this.cfg.getDefaultServerHost());
            }
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Connection to host: " + this.host + " was successful for pubSubData: " + this.pubSubData);
        }
        if (this.pubSubData.operationType.equals((Object)PubSubProtocol.OperationType.PUBLISH)) {
            this.pub.storeHost2ChannelMapping(future.getChannel());
            this.pub.doPublish(this.pubSubData, (Channel)this.pub.host2Channel.get(HedwigClientImpl.getHostFromChannel(future.getChannel())));
        } else if (this.pubSubData.operationType.equals((Object)PubSubProtocol.OperationType.UNSUBSCRIBE)) {
            this.pub.storeHost2ChannelMapping(future.getChannel());
            this.sub.doSubUnsub(this.pubSubData, (Channel)this.pub.host2Channel.get(HedwigClientImpl.getHostFromChannel(future.getChannel())));
        } else {
            this.sub.doSubUnsub(this.pubSubData, future.getChannel());
        }
    }
}

