/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hedwig.client.netty;

import com.google.protobuf.MessageLite;
import org.apache.hedwig.client.netty.HedwigClientImpl;
import org.apache.hedwig.client.netty.ResponseHandler;
import org.apache.hedwig.protocol.PubSubProtocol;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.codec.frame.LengthFieldBasedFrameDecoder;
import org.jboss.netty.handler.codec.frame.LengthFieldPrepender;
import org.jboss.netty.handler.codec.protobuf.ProtobufDecoder;
import org.jboss.netty.handler.codec.protobuf.ProtobufEncoder;
import org.jboss.netty.handler.ssl.SslHandler;

public class ClientChannelPipelineFactory
implements ChannelPipelineFactory {
    private HedwigClientImpl client;

    public ClientChannelPipelineFactory(HedwigClientImpl client) {
        this.client = client;
    }

    public ChannelPipeline getPipeline() throws Exception {
        ChannelPipeline pipeline = Channels.pipeline();
        if (this.client.getSslFactory() != null) {
            pipeline.addLast("ssl", (ChannelHandler)new SslHandler(this.client.getSslFactory().getEngine()));
        }
        pipeline.addLast("lengthbaseddecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(this.client.getConfiguration().getMaximumMessageSize(), 0, 4, 0, 4));
        pipeline.addLast("lengthprepender", (ChannelHandler)new LengthFieldPrepender(4));
        pipeline.addLast("protobufdecoder", (ChannelHandler)new ProtobufDecoder((MessageLite)PubSubProtocol.PubSubResponse.getDefaultInstance()));
        pipeline.addLast("protobufencoder", (ChannelHandler)new ProtobufEncoder());
        pipeline.addLast("responsehandler", (ChannelHandler)new ResponseHandler(this.client));
        return pipeline;
    }
}

