/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hedwig.client.handlers;

import java.util.TimerTask;
import org.apache.hedwig.client.conf.ClientConfiguration;
import org.apache.hedwig.client.data.PubSubData;
import org.apache.hedwig.client.exceptions.AlreadyStartDeliveryException;
import org.apache.hedwig.client.netty.HedwigClientImpl;
import org.apache.hedwig.client.netty.HedwigSubscriber;
import org.apache.hedwig.exceptions.PubSubException;
import org.apache.hedwig.util.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscribeReconnectCallback
implements Callback<Void> {
    private static Logger logger = LoggerFactory.getLogger(SubscribeReconnectCallback.class);
    private final PubSubData origSubData;
    private final HedwigClientImpl client;
    private final HedwigSubscriber sub;
    private final ClientConfiguration cfg;

    public SubscribeReconnectCallback(PubSubData origSubData, HedwigClientImpl client) {
        this.origSubData = origSubData;
        this.client = client;
        this.sub = client.getSubscriber();
        this.cfg = client.getConfiguration();
    }

    @Override
    public void operationFinished(Object ctx, Void resultOfOperation) {
        if (logger.isDebugEnabled()) {
            logger.debug("Subscribe reconnect succeeded for origSubData: " + this.origSubData);
        }
        try {
            this.sub.restartDelivery(this.origSubData.topic, this.origSubData.subscriberId);
        }
        catch (PubSubException.ClientNotSubscribedException e) {
            logger.error("Subscribe was successful but error starting delivery for topic: " + this.origSubData.topic.toStringUtf8() + ", subscriberId: " + this.origSubData.subscriberId.toStringUtf8(), (Throwable)e);
            this.retrySubscribeRequest();
        }
        catch (AlreadyStartDeliveryException alreadyStartDeliveryException) {
            // empty catch block
        }
    }

    @Override
    public void operationFailed(Object ctx, PubSubException exception) {
        logger.error("Subscribe reconnect failed with error: " + exception.getMessage());
        this.retrySubscribeRequest();
    }

    private void retrySubscribeRequest() {
        if (this.client.hasStopped()) {
            return;
        }
        this.client.getClientTimer().schedule((TimerTask)new SubscribeReconnectRetryTask(), this.client.getConfiguration().getSubscribeReconnectRetryWaitTime());
    }

    class SubscribeReconnectRetryTask
    extends TimerTask {
        SubscribeReconnectRetryTask() {
        }

        @Override
        public void run() {
            if (logger.isDebugEnabled()) {
                logger.debug("Retrying subscribe reconnect request for origSubData: " + SubscribeReconnectCallback.this.origSubData);
            }
            SubscribeReconnectCallback.this.origSubData.clearServersList();
            SubscribeReconnectCallback.this.client.doConnect(SubscribeReconnectCallback.this.origSubData, SubscribeReconnectCallback.this.cfg.getDefaultServerHost());
        }
    }
}

