/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hedwig.client.handlers;

import org.apache.hedwig.client.data.PubSubData;
import org.apache.hedwig.exceptions.PubSubException;
import org.apache.hedwig.util.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PubSubCallback
implements Callback<Void> {
    private static Logger logger = LoggerFactory.getLogger(PubSubCallback.class);
    private PubSubData pubSubData;
    private boolean isCallSuccessful;
    private PubSubException failureException;

    public PubSubCallback(PubSubData pubSubData) {
        this.pubSubData = pubSubData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void operationFinished(Object ctx, Void resultOfOperation) {
        if (logger.isDebugEnabled()) {
            logger.debug("PubSub call succeeded for pubSubData: " + this.pubSubData);
        }
        PubSubData pubSubData = this.pubSubData;
        synchronized (pubSubData) {
            this.isCallSuccessful = true;
            this.pubSubData.isDone = true;
            this.pubSubData.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void operationFailed(Object ctx, PubSubException exception) {
        if (logger.isDebugEnabled()) {
            logger.debug("PubSub call failed with exception: " + exception + ", pubSubData: " + this.pubSubData);
        }
        PubSubData pubSubData = this.pubSubData;
        synchronized (pubSubData) {
            this.isCallSuccessful = false;
            this.failureException = exception;
            this.pubSubData.isDone = true;
            this.pubSubData.notify();
        }
    }

    public boolean getIsCallSuccessful() {
        return this.isCallSuccessful;
    }

    public PubSubException getFailureException() {
        return this.failureException;
    }
}

