/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hedwig.client.handlers;

import java.util.TimerTask;
import org.apache.hedwig.client.data.MessageConsumeData;
import org.apache.hedwig.client.data.TopicSubscriber;
import org.apache.hedwig.client.netty.HedwigClientImpl;
import org.apache.hedwig.exceptions.PubSubException;
import org.apache.hedwig.util.Callback;
import org.jboss.netty.channel.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageConsumeCallback
implements Callback<Void> {
    private static Logger logger = LoggerFactory.getLogger(MessageConsumeCallback.class);
    private final HedwigClientImpl client;

    public MessageConsumeCallback(HedwigClientImpl client) {
        this.client = client;
    }

    @Override
    public void operationFinished(Object ctx, Void resultOfOperation) {
        MessageConsumeData messageConsumeData = (MessageConsumeData)ctx;
        TopicSubscriber topicSubscriber = new TopicSubscriber(messageConsumeData.topic, messageConsumeData.subscriberId);
        Channel topicSubscriberChannel = this.client.getSubscriber().getChannelForTopic(topicSubscriber);
        HedwigClientImpl.getResponseHandlerFromChannel(topicSubscriberChannel).getSubscribeResponseHandler().messageConsumed(messageConsumeData.msg);
    }

    @Override
    public void operationFailed(Object ctx, PubSubException exception) {
        MessageConsumeData messageConsumeData = (MessageConsumeData)ctx;
        TopicSubscriber topicSubscriber = new TopicSubscriber(messageConsumeData.topic, messageConsumeData.subscriberId);
        logger.error("Message was not consumed successfully by client MessageHandler: " + messageConsumeData);
        this.client.getClientTimer().schedule((TimerTask)new MessageConsumeRetryTask(messageConsumeData, topicSubscriber), this.client.getConfiguration().getMessageConsumeRetryWaitTime());
    }

    class MessageConsumeRetryTask
    extends TimerTask {
        private final MessageConsumeData messageConsumeData;
        private final TopicSubscriber topicSubscriber;

        public MessageConsumeRetryTask(MessageConsumeData messageConsumeData, TopicSubscriber topicSubscriber) {
            this.messageConsumeData = messageConsumeData;
            this.topicSubscriber = topicSubscriber;
        }

        @Override
        public void run() {
            Channel topicSubscriberChannel = MessageConsumeCallback.this.client.getSubscriber().getChannelForTopic(this.topicSubscriber);
            HedwigClientImpl.getResponseHandlerFromChannel(topicSubscriberChannel).getSubscribeResponseHandler().asyncMessageConsume(this.messageConsumeData.msg);
        }
    }
}

