/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hedwig.client.data;

import com.google.protobuf.ByteString;
import java.util.List;
import org.apache.hedwig.protocol.PubSubProtocol;
import org.apache.hedwig.util.Callback;

public class PubSubData {
    protected static final String COMMA = ", ";
    public final ByteString topic;
    public final PubSubProtocol.Message msg;
    public final ByteString subscriberId;
    public final PubSubProtocol.OperationType operationType;
    public final PubSubProtocol.SubscriptionOptions options;
    public Callback<Void> callback;
    public Object context;
    public List<ByteString> triedServers;
    public List<ByteString> connectFailedServers;
    public List<ByteString> writeFailedServers;
    public boolean shouldClaim = false;
    public long txnId;
    public long requestWriteTime;
    public boolean isDone = false;

    public PubSubData(ByteString topic, PubSubProtocol.Message msg, ByteString subscriberId, PubSubProtocol.OperationType operationType, PubSubProtocol.SubscriptionOptions options, Callback<Void> callback, Object context) {
        this.topic = topic;
        this.msg = msg;
        this.subscriberId = subscriberId;
        this.operationType = operationType;
        this.options = options;
        this.callback = callback;
        this.context = context;
    }

    public void clearServersList() {
        if (this.triedServers != null) {
            this.triedServers.clear();
        }
        if (this.connectFailedServers != null) {
            this.connectFailedServers.clear();
        }
        if (this.writeFailedServers != null) {
            this.writeFailedServers.clear();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.topic != null) {
            sb.append("Topic: " + this.topic.toStringUtf8());
        }
        if (this.msg != null) {
            sb.append(COMMA).append("Message: " + this.msg);
        }
        if (this.subscriberId != null) {
            sb.append(COMMA).append("SubscriberId: " + this.subscriberId.toStringUtf8());
        }
        if (this.operationType != null) {
            sb.append(COMMA).append("Operation Type: " + this.operationType.toString());
        }
        if (this.options != null) {
            sb.append(COMMA).append("Create Or Attach: " + this.options.getCreateOrAttach().toString()).append(COMMA).append("Message Bound: " + this.options.getMessageBound());
        }
        if (this.triedServers != null && this.triedServers.size() > 0) {
            sb.append(COMMA).append("Tried Servers: ");
            for (ByteString triedServer : this.triedServers) {
                sb.append(triedServer.toStringUtf8()).append(COMMA);
            }
        }
        if (this.connectFailedServers != null && this.connectFailedServers.size() > 0) {
            sb.append(COMMA).append("Connect Failed Servers: ");
            for (ByteString connectFailedServer : this.connectFailedServers) {
                sb.append(connectFailedServer.toStringUtf8()).append(COMMA);
            }
        }
        if (this.writeFailedServers != null && this.writeFailedServers.size() > 0) {
            sb.append(COMMA).append("Write Failed Servers: ");
            for (ByteString writeFailedServer : this.writeFailedServers) {
                sb.append(writeFailedServer.toStringUtf8()).append(COMMA);
            }
        }
        sb.append(COMMA).append("Should Claim: " + this.shouldClaim);
        if (this.txnId != 0L) {
            sb.append(COMMA).append("TxnID: " + this.txnId);
        }
        if (this.requestWriteTime != 0L) {
            sb.append(COMMA).append("Request Write Time: " + this.requestWriteTime);
        }
        sb.append(COMMA).append("Is Done: " + this.isDone);
        return sb.toString();
    }
}

