/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bk_v4_2_0.netty.handler.stream;

import java.util.Queue;
import org.jboss.bk_v4_2_0.netty.buffer.ChannelBuffers;
import org.jboss.bk_v4_2_0.netty.channel.Channel;
import org.jboss.bk_v4_2_0.netty.channel.ChannelDownstreamHandler;
import org.jboss.bk_v4_2_0.netty.channel.ChannelEvent;
import org.jboss.bk_v4_2_0.netty.channel.ChannelFuture;
import org.jboss.bk_v4_2_0.netty.channel.ChannelFutureListener;
import org.jboss.bk_v4_2_0.netty.channel.ChannelHandlerContext;
import org.jboss.bk_v4_2_0.netty.channel.ChannelStateEvent;
import org.jboss.bk_v4_2_0.netty.channel.ChannelUpstreamHandler;
import org.jboss.bk_v4_2_0.netty.channel.Channels;
import org.jboss.bk_v4_2_0.netty.channel.MessageEvent;
import org.jboss.bk_v4_2_0.netty.handler.stream.ChunkedInput;
import org.jboss.bk_v4_2_0.netty.logging.InternalLogger;
import org.jboss.bk_v4_2_0.netty.logging.InternalLoggerFactory;
import org.jboss.bk_v4_2_0.netty.util.internal.LinkedTransferQueue;

public class ChunkedWriteHandler
implements ChannelUpstreamHandler,
ChannelDownstreamHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ChunkedWriteHandler.class);
    private final Queue<MessageEvent> queue = new LinkedTransferQueue<MessageEvent>();
    private ChannelHandlerContext ctx;
    private MessageEvent currentEvent;

    public void resumeTransfer() {
        ChannelHandlerContext ctx = this.ctx;
        if (ctx == null) {
            return;
        }
        try {
            this.flush(ctx);
        }
        catch (Exception e) {
            logger.warn("Unexpected exception while sending chunks.", e);
        }
    }

    public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        if (!(e instanceof MessageEvent)) {
            ctx.sendDownstream(e);
            return;
        }
        boolean offered = this.queue.offer((MessageEvent)e);
        assert (offered);
        Channel channel = ctx.getChannel();
        if (channel.isWritable()) {
            this.ctx = ctx;
            this.flush(ctx);
        } else if (!channel.isConnected()) {
            this.ctx = ctx;
            this.discard(ctx);
        }
    }

    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        if (e instanceof ChannelStateEvent) {
            ChannelStateEvent cse = (ChannelStateEvent)e;
            switch (cse.getState()) {
                case INTEREST_OPS: {
                    this.flush(ctx);
                    break;
                }
                case OPEN: {
                    if (Boolean.TRUE.equals(cse.getValue())) break;
                    this.discard(ctx);
                }
            }
        }
        ctx.sendUpstream(e);
    }

    private synchronized void discard(ChannelHandlerContext ctx) {
        while (true) {
            if (this.currentEvent == null) {
                this.currentEvent = this.queue.poll();
            }
            if (this.currentEvent == null) break;
            MessageEvent currentEvent = this.currentEvent;
            this.currentEvent = null;
            Object m = currentEvent.getMessage();
            if (m instanceof ChunkedInput) {
                ChunkedWriteHandler.closeInput((ChunkedInput)m);
                Channels.write(ctx, currentEvent.getFuture(), ChannelBuffers.EMPTY_BUFFER, currentEvent.getRemoteAddress());
            } else {
                ctx.sendDownstream(currentEvent);
            }
            Object var2_2 = null;
        }
    }

    private synchronized void flush(ChannelHandlerContext ctx) throws Exception {
        Channel channel = ctx.getChannel();
        if (!channel.isConnected()) {
            this.discard(ctx);
        }
        while (channel.isWritable()) {
            if (this.currentEvent == null) {
                this.currentEvent = this.queue.poll();
            }
            if (this.currentEvent == null) break;
            if (this.currentEvent.getFuture().isDone()) {
                this.currentEvent = null;
            } else {
                final MessageEvent currentEvent = this.currentEvent;
                Object m = currentEvent.getMessage();
                if (m instanceof ChunkedInput) {
                    ChannelFuture writeFuture;
                    boolean endOfInput;
                    boolean later;
                    Object chunk;
                    ChunkedInput chunks = (ChunkedInput)m;
                    try {
                        chunk = chunks.nextChunk();
                        if (chunk == null) {
                            chunk = ChannelBuffers.EMPTY_BUFFER;
                            later = true;
                        } else {
                            later = false;
                        }
                        endOfInput = chunks.isEndOfInput();
                    }
                    catch (Throwable t) {
                        this.currentEvent = null;
                        currentEvent.getFuture().setFailure(t);
                        Channels.fireExceptionCaught(ctx, t);
                        ChunkedWriteHandler.closeInput(chunks);
                        break;
                    }
                    if (endOfInput) {
                        this.currentEvent = null;
                        ChunkedWriteHandler.closeInput(chunks);
                        writeFuture = currentEvent.getFuture();
                    } else {
                        writeFuture = Channels.future(channel);
                        writeFuture.addListener(new ChannelFutureListener(){

                            public void operationComplete(ChannelFuture future) throws Exception {
                                if (!future.isSuccess()) {
                                    currentEvent.getFuture().setFailure(future.getCause());
                                    ChunkedWriteHandler.closeInput((ChunkedInput)currentEvent.getMessage());
                                }
                            }
                        });
                    }
                    Channels.write(ctx, writeFuture, chunk, currentEvent.getRemoteAddress());
                    if (later) {
                        break;
                    }
                } else {
                    this.currentEvent = null;
                    ctx.sendDownstream(currentEvent);
                }
            }
            if (channel.isConnected()) continue;
            this.discard(ctx);
            break;
        }
    }

    static void closeInput(ChunkedInput chunks) {
        try {
            chunks.close();
        }
        catch (Throwable t) {
            logger.warn("Failed to close a chunked input.", t);
        }
    }
}

