/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bk_v4_2_0.netty.handler.ssl;

import java.nio.ByteBuffer;

public class SslBufferPool {
    private static final int MAX_PACKET_SIZE = 17689;
    private static final int DEFAULT_POOL_SIZE = 18113536;
    private final ByteBuffer[] pool;
    private final int maxBufferCount;
    private int index;

    public SslBufferPool() {
        this(18113536);
    }

    public SslBufferPool(int maxPoolSize) {
        if (maxPoolSize <= 0) {
            throw new IllegalArgumentException("maxPoolSize: " + maxPoolSize);
        }
        int maxBufferCount = maxPoolSize / 17689;
        if (maxPoolSize % 17689 != 0) {
            ++maxBufferCount;
        }
        this.pool = new ByteBuffer[maxBufferCount];
        this.maxBufferCount = maxBufferCount;
    }

    public int getMaxPoolSize() {
        return this.maxBufferCount * 17689;
    }

    public synchronized int getUnacquiredPoolSize() {
        return this.index * 17689;
    }

    synchronized ByteBuffer acquire() {
        if (this.index == 0) {
            return ByteBuffer.allocate(17689);
        }
        return (ByteBuffer)this.pool[--this.index].clear();
    }

    synchronized void release(ByteBuffer buffer) {
        if (this.index < this.maxBufferCount) {
            this.pool[this.index++] = buffer;
        }
    }
}

