/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bk_v4_2_0.netty.handler.codec.protobuf;

import bk-shade.com.google.proto_bk_v4_2_0.ExtensionRegistry;
import bk-shade.com.google.proto_bk_v4_2_0.ExtensionRegistryLite;
import bk-shade.com.google.proto_bk_v4_2_0.MessageLite;
import org.jboss.bk_v4_2_0.netty.buffer.ChannelBuffer;
import org.jboss.bk_v4_2_0.netty.buffer.ChannelBufferInputStream;
import org.jboss.bk_v4_2_0.netty.channel.Channel;
import org.jboss.bk_v4_2_0.netty.channel.ChannelHandler;
import org.jboss.bk_v4_2_0.netty.channel.ChannelHandlerContext;
import org.jboss.bk_v4_2_0.netty.handler.codec.oneone.OneToOneDecoder;

@ChannelHandler.Sharable
public class ProtobufDecoder
extends OneToOneDecoder {
    private final MessageLite prototype;
    private final ExtensionRegistry extensionRegistry;

    public ProtobufDecoder(MessageLite prototype) {
        this(prototype, null);
    }

    public ProtobufDecoder(MessageLite prototype, ExtensionRegistry extensionRegistry) {
        if (prototype == null) {
            throw new NullPointerException("prototype");
        }
        this.prototype = prototype.getDefaultInstanceForType();
        this.extensionRegistry = extensionRegistry;
    }

    protected Object decode(ChannelHandlerContext ctx, Channel channel, Object msg) throws Exception {
        if (!(msg instanceof ChannelBuffer)) {
            return msg;
        }
        ChannelBuffer buf = (ChannelBuffer)msg;
        if (buf.hasArray()) {
            int offset = buf.readerIndex();
            if (this.extensionRegistry == null) {
                return this.prototype.newBuilderForType().mergeFrom(buf.array(), buf.arrayOffset() + offset, buf.readableBytes()).build();
            }
            return this.prototype.newBuilderForType().mergeFrom(buf.array(), buf.arrayOffset() + offset, buf.readableBytes(), this.extensionRegistry).build();
        }
        if (this.extensionRegistry == null) {
            return this.prototype.newBuilderForType().mergeFrom(new ChannelBufferInputStream((ChannelBuffer)msg)).build();
        }
        return this.prototype.newBuilderForType().mergeFrom(new ChannelBufferInputStream((ChannelBuffer)msg), (ExtensionRegistryLite)this.extensionRegistry).build();
    }
}

