/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bk_v4_2_0.netty.channel.local;

import java.net.SocketAddress;
import org.jboss.bk_v4_2_0.netty.channel.AbstractChannelSink;
import org.jboss.bk_v4_2_0.netty.channel.Channel;
import org.jboss.bk_v4_2_0.netty.channel.ChannelEvent;
import org.jboss.bk_v4_2_0.netty.channel.ChannelException;
import org.jboss.bk_v4_2_0.netty.channel.ChannelFuture;
import org.jboss.bk_v4_2_0.netty.channel.ChannelPipeline;
import org.jboss.bk_v4_2_0.netty.channel.ChannelState;
import org.jboss.bk_v4_2_0.netty.channel.ChannelStateEvent;
import org.jboss.bk_v4_2_0.netty.channel.Channels;
import org.jboss.bk_v4_2_0.netty.channel.MessageEvent;
import org.jboss.bk_v4_2_0.netty.channel.local.DefaultLocalChannel;
import org.jboss.bk_v4_2_0.netty.channel.local.DefaultLocalServerChannel;
import org.jboss.bk_v4_2_0.netty.channel.local.LocalAddress;
import org.jboss.bk_v4_2_0.netty.channel.local.LocalChannelRegistry;

final class LocalServerChannelSink
extends AbstractChannelSink {
    LocalServerChannelSink() {
    }

    public void eventSunk(ChannelPipeline pipeline, ChannelEvent e) throws Exception {
        Channel channel = e.getChannel();
        if (channel instanceof DefaultLocalServerChannel) {
            this.handleServerChannel(e);
        } else if (channel instanceof DefaultLocalChannel) {
            this.handleAcceptedChannel(e);
        }
    }

    private void handleServerChannel(ChannelEvent e) {
        if (!(e instanceof ChannelStateEvent)) {
            return;
        }
        ChannelStateEvent event = (ChannelStateEvent)e;
        DefaultLocalServerChannel channel = (DefaultLocalServerChannel)event.getChannel();
        ChannelFuture future = event.getFuture();
        ChannelState state = event.getState();
        Object value = event.getValue();
        switch (state) {
            case OPEN: {
                if (!Boolean.FALSE.equals(value)) break;
                this.close(channel, future);
                break;
            }
            case BOUND: {
                if (value != null) {
                    this.bind(channel, future, (LocalAddress)value);
                    break;
                }
                this.close(channel, future);
            }
        }
    }

    private void handleAcceptedChannel(ChannelEvent e) {
        if (e instanceof ChannelStateEvent) {
            ChannelStateEvent event = (ChannelStateEvent)e;
            DefaultLocalChannel channel = (DefaultLocalChannel)event.getChannel();
            ChannelFuture future = event.getFuture();
            ChannelState state = event.getState();
            Object value = event.getValue();
            switch (state) {
                case OPEN: {
                    if (!Boolean.FALSE.equals(value)) break;
                    channel.closeNow(future);
                    break;
                }
                case BOUND: 
                case CONNECTED: {
                    if (value != null) break;
                    channel.closeNow(future);
                    break;
                }
                case INTEREST_OPS: {
                    future.setSuccess();
                }
            }
        } else if (e instanceof MessageEvent) {
            MessageEvent event = (MessageEvent)e;
            DefaultLocalChannel channel = (DefaultLocalChannel)event.getChannel();
            boolean offered = channel.writeBuffer.offer(event);
            assert (offered);
            channel.flushWriteBuffer();
        }
    }

    private void bind(DefaultLocalServerChannel channel, ChannelFuture future, LocalAddress localAddress) {
        try {
            if (!LocalChannelRegistry.register(localAddress, channel)) {
                throw new ChannelException("address already in use: " + localAddress);
            }
            if (!channel.bound.compareAndSet(false, true)) {
                throw new ChannelException("already bound");
            }
            channel.localAddress = localAddress;
            future.setSuccess();
            Channels.fireChannelBound(channel, (SocketAddress)localAddress);
        }
        catch (Throwable t) {
            LocalChannelRegistry.unregister(localAddress);
            future.setFailure(t);
            Channels.fireExceptionCaught(channel, t);
        }
    }

    private void close(DefaultLocalServerChannel channel, ChannelFuture future) {
        try {
            if (channel.setClosed()) {
                future.setSuccess();
                LocalAddress localAddress = channel.localAddress;
                if (channel.bound.compareAndSet(true, false)) {
                    channel.localAddress = null;
                    LocalChannelRegistry.unregister(localAddress);
                    Channels.fireChannelUnbound(channel);
                }
                Channels.fireChannelClosed(channel);
            } else {
                future.setSuccess();
            }
        }
        catch (Throwable t) {
            future.setFailure(t);
            Channels.fireExceptionCaught(channel, t);
        }
    }
}

