/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bk_v4_2_0.commons.configuration;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import org.apache.bk_v4_2_0.commons.configuration.CompositeConfiguration;
import org.apache.bk_v4_2_0.commons.configuration.Configuration;
import org.apache.bk_v4_2_0.commons.configuration.ConfigurationException;
import org.apache.bk_v4_2_0.commons.configuration.ConfigurationUtils;
import org.apache.bk_v4_2_0.commons.configuration.FileConfiguration;
import org.apache.bk_v4_2_0.commons.configuration.HierarchicalConfiguration;
import org.apache.bk_v4_2_0.commons.configuration.PropertiesConfiguration;
import org.apache.bk_v4_2_0.commons.configuration.PropertyConverter;
import org.apache.bk_v4_2_0.commons.configuration.XMLPropertiesConfiguration;
import org.apache.bk_v4_2_0.commons.configuration.plist.PropertyListConfiguration;
import org.apache.bk_v4_2_0.commons.configuration.plist.XMLPropertyListConfiguration;
import org.apache.bk_v4_2_0.commons.digester.AbstractObjectCreationFactory;
import org.apache.bk_v4_2_0.commons.digester.CallMethodRule;
import org.apache.bk_v4_2_0.commons.digester.Digester;
import org.apache.bk_v4_2_0.commons.digester.ObjectCreationFactory;
import org.apache.bk_v4_2_0.commons.digester.substitution.MultiVariableExpander;
import org.apache.bk_v4_2_0.commons.digester.substitution.VariableSubstitutor;
import org.apache.bk_v4_2_0.commons.digester.xmlrules.DigesterLoader;
import org.apache.bk_v4_2_0.commons.lang.StringUtils;
import org.apache.bk_v4_2_0.commons.logging.Log;
import org.apache.bk_v4_2_0.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ConfigurationFactory {
    private static final String SEC_ROOT = "configuration/";
    private static final String SEC_OVERRIDE = "configuration/override/";
    private static final String SEC_ADDITIONAL = "configuration/additional/";
    private static final String ATTR_OPTIONAL = "optional";
    private static final String ATTR_FILENAME = "fileName";
    private static final String METH_LOAD = "load";
    private static final String DEF_BASE_PATH = ".";
    private static Log log = LogFactory.getLog(class$org$apache$commons$configuration$ConfigurationFactory == null ? (class$org$apache$commons$configuration$ConfigurationFactory = ConfigurationFactory.class$("org.apache.bk_v4_2_0.commons.configuration.ConfigurationFactory")) : class$org$apache$commons$configuration$ConfigurationFactory);
    private String configurationFileName;
    private URL configurationURL;
    private String implicitBasePath;
    private String basePath;
    private URL digesterRules;
    private String digesterRuleNamespaceURI;
    static /* synthetic */ Class class$org$apache$commons$configuration$ConfigurationFactory;
    static /* synthetic */ Class class$org$apache$commons$configuration$XMLConfiguration;
    static /* synthetic */ Class class$org$apache$commons$configuration$Configuration;
    static /* synthetic */ Class class$org$apache$commons$configuration$ConfigurationFactory$AdditionalConfigurationData;
    static /* synthetic */ Class class$org$apache$commons$configuration$JNDIConfiguration;
    static /* synthetic */ Class class$org$apache$commons$configuration$SystemConfiguration;

    public ConfigurationFactory() {
        this.setBasePath(DEF_BASE_PATH);
    }

    public ConfigurationFactory(String configurationFileName) {
        this.setConfigurationFileName(configurationFileName);
    }

    public Configuration getConfiguration() throws ConfigurationException {
        Digester digester;
        InputStream input = null;
        ConfigurationBuilder builder = new ConfigurationBuilder();
        URL url = this.getConfigurationURL();
        try {
            if (url == null) {
                url = ConfigurationUtils.locate(this.implicitBasePath, this.getConfigurationFileName());
            }
            input = url.openStream();
        }
        catch (Exception e) {
            log.error("Exception caught opening stream to URL", e);
            throw new ConfigurationException("Exception caught opening stream to URL", e);
        }
        if (this.getDigesterRules() == null) {
            digester = new Digester();
            this.configureNamespace(digester);
            this.initDefaultDigesterRules(digester);
        } else {
            digester = DigesterLoader.createDigester(this.getDigesterRules());
            this.configureNamespace(digester);
        }
        digester.setUseContextClassLoader(true);
        this.enableDigesterSubstitutor(digester);
        digester.push(builder);
        try {
            digester.parse(input);
            input.close();
        }
        catch (SAXException saxe) {
            log.error("SAX Exception caught", saxe);
            throw new ConfigurationException("SAX Exception caught", saxe);
        }
        catch (IOException ioe) {
            log.error("IO Exception caught", ioe);
            throw new ConfigurationException("IO Exception caught", ioe);
        }
        return builder.getConfiguration();
    }

    public String getConfigurationFileName() {
        return this.configurationFileName;
    }

    public void setConfigurationFileName(String configurationFileName) {
        File file = new File(configurationFileName).getAbsoluteFile();
        this.configurationFileName = file.getName();
        this.implicitBasePath = file.getParent();
    }

    public URL getConfigurationURL() {
        return this.configurationURL;
    }

    public void setConfigurationURL(URL url) {
        this.configurationURL = url;
        this.implicitBasePath = url.toString();
    }

    public URL getDigesterRules() {
        return this.digesterRules;
    }

    public void setDigesterRules(URL digesterRules) {
        this.digesterRules = digesterRules;
    }

    protected void enableDigesterSubstitutor(Digester digester) {
        Properties systemProperties = System.getProperties();
        MultiVariableExpander expander = new MultiVariableExpander();
        expander.addSource("$", systemProperties);
        VariableSubstitutor substitutor = new VariableSubstitutor(expander);
        digester.setSubstitutor(substitutor);
    }

    protected void initDefaultDigesterRules(Digester digester) {
        this.initDigesterSectionRules(digester, SEC_ROOT, false);
        this.initDigesterSectionRules(digester, SEC_OVERRIDE, false);
        this.initDigesterSectionRules(digester, SEC_ADDITIONAL, true);
    }

    protected void initDigesterSectionRules(Digester digester, String matchString, boolean additional) {
        this.setupDigesterInstance(digester, matchString + "properties", new PropertiesConfigurationFactory(), METH_LOAD, additional);
        this.setupDigesterInstance(digester, matchString + "plist", new PropertyListConfigurationFactory(), METH_LOAD, additional);
        this.setupDigesterInstance(digester, matchString + "xml", new FileConfigurationFactory(class$org$apache$commons$configuration$XMLConfiguration == null ? (class$org$apache$commons$configuration$XMLConfiguration = ConfigurationFactory.class$("org.apache.bk_v4_2_0.commons.configuration.XMLConfiguration")) : class$org$apache$commons$configuration$XMLConfiguration), METH_LOAD, additional);
        this.setupDigesterInstance(digester, matchString + "hierarchicalXml", new FileConfigurationFactory(class$org$apache$commons$configuration$XMLConfiguration == null ? (class$org$apache$commons$configuration$XMLConfiguration = ConfigurationFactory.class$("org.apache.bk_v4_2_0.commons.configuration.XMLConfiguration")) : class$org$apache$commons$configuration$XMLConfiguration), METH_LOAD, additional);
        this.setupDigesterInstance(digester, matchString + "jndi", new JNDIConfigurationFactory(), null, additional);
        this.setupDigesterInstance(digester, matchString + "system", new SystemConfigurationFactory(), null, additional);
    }

    protected void setupDigesterInstance(Digester digester, String matchString, ObjectCreationFactory factory, String method, boolean additional) {
        if (additional) {
            this.setupUnionRules(digester, matchString);
        }
        digester.addFactoryCreate(matchString, factory);
        digester.addSetProperties(matchString);
        if (method != null) {
            digester.addRule(matchString, new CallOptionalMethodRule(method));
        }
        digester.addSetNext(matchString, "addConfiguration", (class$org$apache$commons$configuration$Configuration == null ? (class$org$apache$commons$configuration$Configuration = ConfigurationFactory.class$("org.apache.bk_v4_2_0.commons.configuration.Configuration")) : class$org$apache$commons$configuration$Configuration).getName());
    }

    protected void setupUnionRules(Digester digester, String matchString) {
        digester.addObjectCreate(matchString, class$org$apache$commons$configuration$ConfigurationFactory$AdditionalConfigurationData == null ? (class$org$apache$commons$configuration$ConfigurationFactory$AdditionalConfigurationData = ConfigurationFactory.class$("org.apache.bk_v4_2_0.commons.configuration.ConfigurationFactory$AdditionalConfigurationData")) : class$org$apache$commons$configuration$ConfigurationFactory$AdditionalConfigurationData);
        digester.addSetProperties(matchString);
        digester.addSetNext(matchString, "addAdditionalConfig", (class$org$apache$commons$configuration$ConfigurationFactory$AdditionalConfigurationData == null ? (class$org$apache$commons$configuration$ConfigurationFactory$AdditionalConfigurationData = ConfigurationFactory.class$("org.apache.bk_v4_2_0.commons.configuration.ConfigurationFactory$AdditionalConfigurationData")) : class$org$apache$commons$configuration$ConfigurationFactory$AdditionalConfigurationData).getName());
    }

    public String getDigesterRuleNamespaceURI() {
        return this.digesterRuleNamespaceURI;
    }

    public void setDigesterRuleNamespaceURI(String digesterRuleNamespaceURI) {
        this.digesterRuleNamespaceURI = digesterRuleNamespaceURI;
    }

    private void configureNamespace(Digester digester) {
        if (this.getDigesterRuleNamespaceURI() != null) {
            digester.setNamespaceAware(true);
            digester.setRuleNamespaceURI(this.getDigesterRuleNamespaceURI());
        } else {
            digester.setNamespaceAware(false);
        }
        digester.setValidating(false);
    }

    public String getBasePath() {
        String path = StringUtils.isEmpty(this.basePath) || DEF_BASE_PATH.equals(this.basePath) ? this.implicitBasePath : this.basePath;
        return StringUtils.isEmpty(path) ? DEF_BASE_PATH : path;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class CallOptionalMethodRule
    extends CallMethodRule {
        private boolean optional;

        public CallOptionalMethodRule(String methodName) {
            super(methodName);
        }

        public void begin(Attributes attrs) throws Exception {
            this.optional = attrs.getValue(ConfigurationFactory.ATTR_OPTIONAL) != null && PropertyConverter.toBoolean(attrs.getValue(ConfigurationFactory.ATTR_OPTIONAL)) != false;
            super.begin(attrs);
        }

        public void end() throws Exception {
            try {
                super.end();
            }
            catch (Exception ex) {
                if (this.optional) {
                    log.warn("Could not create optional configuration!", ex);
                }
                throw ex;
            }
        }
    }

    public static class ConfigurationBuilder {
        private CompositeConfiguration config = new CompositeConfiguration();
        private Collection additionalConfigs = new LinkedList();

        public void addConfiguration(Configuration conf) {
            this.config.addConfiguration(conf);
        }

        public void addAdditionalConfig(AdditionalConfigurationData data) {
            this.additionalConfigs.add(data);
        }

        public CompositeConfiguration getConfiguration() {
            if (!this.additionalConfigs.isEmpty()) {
                Configuration unionConfig = this.createAdditionalConfiguration(this.additionalConfigs);
                if (unionConfig != null) {
                    this.addConfiguration(unionConfig);
                }
                this.additionalConfigs.clear();
            }
            return this.config;
        }

        protected Configuration createAdditionalConfiguration(Collection configs) {
            HierarchicalConfiguration result = new HierarchicalConfiguration();
            Iterator it = configs.iterator();
            while (it.hasNext()) {
                AdditionalConfigurationData cdata = (AdditionalConfigurationData)it.next();
                result.addNodes(cdata.getAt(), this.createRootNode(cdata).getChildren());
            }
            return result.isEmpty() ? null : result;
        }

        private HierarchicalConfiguration.Node createRootNode(AdditionalConfigurationData cdata) {
            if (cdata.getConfiguration() instanceof HierarchicalConfiguration) {
                return ((HierarchicalConfiguration)cdata.getConfiguration()).getRoot();
            }
            HierarchicalConfiguration hc = new HierarchicalConfiguration();
            ConfigurationUtils.copy(cdata.getConfiguration(), hc);
            return hc.getRoot();
        }
    }

    public static class AdditionalConfigurationData {
        private Configuration configuration;
        private String at;

        public String getAt() {
            return this.at;
        }

        public void setAt(String string) {
            this.at = string;
        }

        public Configuration getConfiguration() {
            return this.configuration;
        }

        public void addConfiguration(Configuration config) {
            this.configuration = config;
        }
    }

    private class SystemConfigurationFactory
    extends DigesterConfigurationFactory {
        public SystemConfigurationFactory() {
            super(class$org$apache$commons$configuration$SystemConfiguration == null ? (class$org$apache$commons$configuration$SystemConfiguration = ConfigurationFactory.class$("org.apache.bk_v4_2_0.commons.configuration.SystemConfiguration")) : class$org$apache$commons$configuration$SystemConfiguration);
        }
    }

    private class JNDIConfigurationFactory
    extends DigesterConfigurationFactory {
        public JNDIConfigurationFactory() {
            super(class$org$apache$commons$configuration$JNDIConfiguration == null ? (class$org$apache$commons$configuration$JNDIConfiguration = ConfigurationFactory.class$("org.apache.bk_v4_2_0.commons.configuration.JNDIConfiguration")) : class$org$apache$commons$configuration$JNDIConfiguration);
        }
    }

    public class PropertyListConfigurationFactory
    extends FileConfigurationFactory {
        public PropertyListConfigurationFactory() {
            super(null);
        }

        protected FileConfiguration createConfiguration(Attributes attributes) throws Exception {
            String filename = attributes.getValue(ConfigurationFactory.ATTR_FILENAME);
            if (filename != null && filename.toLowerCase().trim().endsWith(".xml")) {
                return new XMLPropertyListConfiguration();
            }
            return new PropertyListConfiguration();
        }
    }

    public class PropertiesConfigurationFactory
    extends FileConfigurationFactory {
        public PropertiesConfigurationFactory() {
            super(null);
        }

        protected FileConfiguration createConfiguration(Attributes attributes) throws Exception {
            String filename = attributes.getValue(ConfigurationFactory.ATTR_FILENAME);
            if (filename != null && filename.toLowerCase().trim().endsWith(".xml")) {
                return new XMLPropertiesConfiguration();
            }
            return new PropertiesConfiguration();
        }
    }

    public class FileConfigurationFactory
    extends DigesterConfigurationFactory {
        public FileConfigurationFactory(Class clazz) {
            super(clazz);
        }

        public Object createObject(Attributes attributes) throws Exception {
            FileConfiguration conf = this.createConfiguration(attributes);
            conf.setBasePath(ConfigurationFactory.this.getBasePath());
            return conf;
        }

        protected FileConfiguration createConfiguration(Attributes attributes) throws Exception {
            return (FileConfiguration)super.createObject(attributes);
        }
    }

    public class DigesterConfigurationFactory
    extends AbstractObjectCreationFactory {
        private Class clazz;

        public DigesterConfigurationFactory(Class clazz) {
            this.clazz = clazz;
        }

        public Object createObject(Attributes attribs) throws Exception {
            return this.clazz.newInstance();
        }
    }
}

