/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bk_v4_2_0.bookkeeper.zookeeper;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.bk_v4_2_0.bookkeeper.KeeperException;
import org.apache.bk_v4_2_0.bookkeeper.WatchedEvent;
import org.apache.bk_v4_2_0.bookkeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperWatcherBase
implements Watcher {
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperWatcherBase.class);
    private final int zkSessionTimeOut;
    private CountDownLatch clientConnectLatch = new CountDownLatch(1);

    public ZooKeeperWatcherBase(int zkSessionTimeOut) {
        this.zkSessionTimeOut = zkSessionTimeOut;
    }

    @Override
    public void process(WatchedEvent event) {
        if (event.getType() != Watcher.Event.EventType.None) {
            LOG.debug("Recieved event: {}, path: {} from ZooKeeper server", (Object)event.getType(), (Object)event.getPath());
            return;
        }
        LOG.debug("Recieved {} from ZooKeeper server", (Object)event.getState());
        switch (event.getState()) {
            case SyncConnected: {
                this.clientConnectLatch.countDown();
                break;
            }
            case Disconnected: {
                LOG.debug("Ignoring Disconnected event from ZooKeeper server");
                break;
            }
            case Expired: {
                LOG.error("ZooKeeper client connection to the ZooKeeper server has expired!");
            }
        }
    }

    public void waitForConnection() throws KeeperException, InterruptedException {
        if (!this.clientConnectLatch.await(this.zkSessionTimeOut, TimeUnit.MILLISECONDS)) {
            throw KeeperException.create(KeeperException.Code.CONNECTIONLOSS);
        }
    }

    public int getZkSessionTimeOut() {
        return this.zkSessionTimeOut;
    }
}

