/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bk_v4_2_0.bookkeeper.util;

import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.bk_v4_2_0.commons.configuration.Configuration;
import org.apache.bk_v4_2_0.commons.configuration.ConfigurationException;

public class ReflectionUtils {
    private static final Map<Class<?>, Constructor<?>> constructorCache = new ConcurrentHashMap();

    public static Class<?> getClass(Configuration conf, String name, Class<?> defaultCls, ClassLoader classLoader) throws ConfigurationException {
        String valueStr = conf.getString(name);
        if (null == valueStr) {
            return defaultCls;
        }
        try {
            return Class.forName(valueStr, true, classLoader);
        }
        catch (ClassNotFoundException cnfe) {
            throw new ConfigurationException(cnfe);
        }
    }

    public static <U> Class<? extends U> getClass(Configuration conf, String name, Class<? extends U> defaultValue, Class<U> xface, ClassLoader classLoader) throws ConfigurationException {
        try {
            Class<?> theCls = ReflectionUtils.getClass(conf, name, defaultValue, classLoader);
            if (null != theCls && !xface.isAssignableFrom(theCls)) {
                throw new ConfigurationException(theCls + " not " + xface.getName());
            }
            if (null != theCls) {
                return theCls.asSubclass(xface);
            }
            return null;
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    public static <T> T newInstance(Class<T> theCls) {
        Object result;
        try {
            Constructor<Object> meth = constructorCache.get(theCls);
            if (null == meth) {
                meth = theCls.getDeclaredConstructor(new Class[0]);
                meth.setAccessible(true);
                constructorCache.put(theCls, meth);
            }
            result = meth.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return (T)result;
    }

    public static <T> T newInstance(String clsName, Class<T> xface) {
        Class<?> theCls;
        try {
            theCls = Class.forName(clsName);
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException(cnfe);
        }
        if (!xface.isAssignableFrom(theCls)) {
            throw new RuntimeException(clsName + " not " + xface.getName());
        }
        return ReflectionUtils.newInstance(theCls.asSubclass(xface));
    }
}

