/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bk_v4_2_0.bookkeeper.util;

import java.io.Closeable;
import java.io.IOException;
import org.slf4j.Logger;

public class IOUtils {
    public static void close(Logger log, Closeable ... closeables) {
        for (Closeable c : closeables) {
            if (c == null) continue;
            try {
                c.close();
            }
            catch (IOException e) {
                if (log == null || !log.isDebugEnabled()) continue;
                log.debug("Exception in closing " + c, (Throwable)e);
            }
        }
    }

    public static boolean confirmPrompt(String prompt) throws IOException {
        while (true) {
            int c;
            System.out.print(prompt + " (Y or N) ");
            StringBuilder responseBuilder = new StringBuilder();
            while ((c = System.in.read()) != -1 && c != 13 && c != 10) {
                responseBuilder.append((char)c);
            }
            String response = responseBuilder.toString();
            if (response.equalsIgnoreCase("y") || response.equalsIgnoreCase("yes")) {
                return true;
            }
            if (response.equalsIgnoreCase("n") || response.equalsIgnoreCase("no")) {
                return false;
            }
            System.out.println("Invalid input: " + response);
        }
    }
}

