/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bk_v4_2_0.bookkeeper.util;

import java.io.InputStream;
import org.apache.bk_v4_2_0.bookkeeper.util.StringEntryFormatter;
import org.apache.bk_v4_2_0.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EntryFormatter {
    static Logger LOG = LoggerFactory.getLogger(EntryFormatter.class);
    protected Configuration conf;
    public static final EntryFormatter STRING_FORMATTER = new StringEntryFormatter();

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public abstract void formatEntry(byte[] var1);

    public abstract void formatEntry(InputStream var1);

    public static EntryFormatter newEntryFormatter(Configuration conf, String clsProperty) {
        EntryFormatter formatter;
        String cls = conf.getString(clsProperty, StringEntryFormatter.class.getName());
        ClassLoader classLoader = EntryFormatter.class.getClassLoader();
        try {
            Class<?> aCls = classLoader.loadClass(cls);
            formatter = (EntryFormatter)aCls.newInstance();
            formatter.setConf(conf);
        }
        catch (Exception e) {
            LOG.warn("No formatter class found : " + cls, (Throwable)e);
            LOG.warn("Using Default String Formatter.");
            formatter = STRING_FORMATTER;
        }
        return formatter;
    }
}

