/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bk_v4_2_0.bookkeeper.util;

import com.google.bk_v4_2_0.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;

public class DiskChecker {
    private float diskUsageThreshold;

    public DiskChecker(float threshold) {
        this.validateThreshold(threshold);
        this.diskUsageThreshold = threshold;
    }

    private static boolean mkdirsWithExistsCheck(File dir) {
        if (dir.mkdir() || dir.exists()) {
            return true;
        }
        File canonDir = null;
        try {
            canonDir = dir.getCanonicalFile();
        }
        catch (IOException e) {
            return false;
        }
        String parent = canonDir.getParent();
        return parent != null && DiskChecker.mkdirsWithExistsCheck(new File(parent)) && (canonDir.mkdir() || canonDir.exists());
    }

    @VisibleForTesting
    void checkDiskFull(File dir) throws DiskOutOfSpaceException {
        if (null == dir) {
            return;
        }
        if (dir.exists()) {
            long totalSpace;
            long usableSpace = dir.getUsableSpace();
            float free = (float)usableSpace / (float)(totalSpace = dir.getTotalSpace());
            float used = 1.0f - free;
            if (used > this.diskUsageThreshold) {
                throw new DiskOutOfSpaceException("Space left on device " + usableSpace + " < threshhold " + this.diskUsageThreshold);
            }
        } else {
            this.checkDiskFull(dir.getParentFile());
        }
    }

    public void checkDir(File dir) throws DiskErrorException, DiskOutOfSpaceException {
        this.checkDiskFull(dir);
        if (!DiskChecker.mkdirsWithExistsCheck(dir)) {
            throw new DiskErrorException("can not create directory: " + dir.toString());
        }
        if (!dir.isDirectory()) {
            throw new DiskErrorException("not a directory: " + dir.toString());
        }
        if (!dir.canRead()) {
            throw new DiskErrorException("directory is not readable: " + dir.toString());
        }
        if (!dir.canWrite()) {
            throw new DiskErrorException("directory is not writable: " + dir.toString());
        }
    }

    @VisibleForTesting
    float getDiskSpaceThreshold() {
        return this.diskUsageThreshold;
    }

    @VisibleForTesting
    void setDiskSpaceThreshold(float diskSpaceThreshold) {
        this.validateThreshold(diskSpaceThreshold);
        this.diskUsageThreshold = diskSpaceThreshold;
    }

    private void validateThreshold(float diskSpaceThreshold) {
        if (diskSpaceThreshold <= 0.0f || diskSpaceThreshold >= 1.0f) {
            throw new IllegalArgumentException("Disk space threashold " + diskSpaceThreshold + " is not valid. Should be > 0 and < 1 ");
        }
    }

    public static class DiskOutOfSpaceException
    extends IOException {
        private static final long serialVersionUID = 160898797915906860L;

        public DiskOutOfSpaceException(String msg) {
            super(msg);
        }
    }

    public static class DiskErrorException
    extends IOException {
        private static final long serialVersionUID = 9091606022449761729L;

        public DiskErrorException(String msg) {
            super(msg);
        }
    }
}

