/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bk_v4_2_0.bookkeeper.server.quorum;

import org.apache.bk_v4_2_0.bookkeeper.server.Request;
import org.apache.bk_v4_2_0.bookkeeper.server.RequestProcessor;
import org.apache.bk_v4_2_0.bookkeeper.server.SyncRequestProcessor;
import org.apache.bk_v4_2_0.bookkeeper.server.quorum.AckRequestProcessor;
import org.apache.bk_v4_2_0.bookkeeper.server.quorum.LeaderZooKeeperServer;
import org.apache.bk_v4_2_0.bookkeeper.server.quorum.LearnerSyncRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProposalRequestProcessor
implements RequestProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ProposalRequestProcessor.class);
    LeaderZooKeeperServer zks;
    RequestProcessor nextProcessor;
    SyncRequestProcessor syncProcessor;

    public ProposalRequestProcessor(LeaderZooKeeperServer zks, RequestProcessor nextProcessor) {
        this.zks = zks;
        this.nextProcessor = nextProcessor;
        AckRequestProcessor ackProcessor = new AckRequestProcessor(zks.getLeader());
        this.syncProcessor = new SyncRequestProcessor(zks, ackProcessor);
    }

    public void initialize() {
        this.syncProcessor.start();
    }

    public void processRequest(Request request) {
        if (request instanceof LearnerSyncRequest) {
            this.zks.getLeader().processSync((LearnerSyncRequest)request);
        } else {
            this.nextProcessor.processRequest(request);
            if (request.hdr != null) {
                this.zks.getLeader().propose(request);
                this.syncProcessor.processRequest(request);
            }
        }
    }

    public void shutdown() {
        LOG.info("Shutting down");
        this.nextProcessor.shutdown();
        this.syncProcessor.shutdown();
    }
}

