/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bk_v4_2_0.bookkeeper.server.quorum;

import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.bk_v4_2_0.bookkeeper.server.FinalRequestProcessor;
import org.apache.bk_v4_2_0.bookkeeper.server.Request;
import org.apache.bk_v4_2_0.bookkeeper.server.SyncRequestProcessor;
import org.apache.bk_v4_2_0.bookkeeper.server.ZKDatabase;
import org.apache.bk_v4_2_0.bookkeeper.server.ZooKeeperServer;
import org.apache.bk_v4_2_0.bookkeeper.server.persistence.FileTxnSnapLog;
import org.apache.bk_v4_2_0.bookkeeper.server.quorum.CommitProcessor;
import org.apache.bk_v4_2_0.bookkeeper.server.quorum.Learner;
import org.apache.bk_v4_2_0.bookkeeper.server.quorum.LearnerZooKeeperServer;
import org.apache.bk_v4_2_0.bookkeeper.server.quorum.Observer;
import org.apache.bk_v4_2_0.bookkeeper.server.quorum.ObserverRequestProcessor;
import org.apache.bk_v4_2_0.bookkeeper.server.quorum.QuorumPeer;
import org.apache.bk_v4_2_0.bookkeeper.server.quorum.SendAckRequestProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObserverZooKeeperServer
extends LearnerZooKeeperServer {
    private static final Logger LOG = LoggerFactory.getLogger(ObserverZooKeeperServer.class);
    private CommitProcessor commitProcessor;
    private SyncRequestProcessor syncProcessor;
    ConcurrentLinkedQueue<Request> pendingSyncs = new ConcurrentLinkedQueue();

    ObserverZooKeeperServer(FileTxnSnapLog logFactory, QuorumPeer self, ZooKeeperServer.DataTreeBuilder treeBuilder, ZKDatabase zkDb) throws IOException {
        super(logFactory, self.tickTime, self.minSessionTimeout, self.maxSessionTimeout, treeBuilder, zkDb, self);
    }

    public Observer getObserver() {
        return this.self.observer;
    }

    public Learner getLearner() {
        return this.self.observer;
    }

    public void commitRequest(Request request) {
        this.commitProcessor.commit(request);
    }

    protected void setupRequestProcessors() {
        FinalRequestProcessor finalProcessor = new FinalRequestProcessor(this);
        this.commitProcessor = new CommitProcessor(finalProcessor, Long.toString(this.getServerId()), true);
        this.commitProcessor.start();
        this.firstProcessor = new ObserverRequestProcessor(this, this.commitProcessor);
        ((ObserverRequestProcessor)this.firstProcessor).start();
        this.syncProcessor = new SyncRequestProcessor(this, new SendAckRequestProcessor(this.getObserver()));
        this.syncProcessor.start();
    }

    public synchronized void sync() {
        if (this.pendingSyncs.size() == 0) {
            LOG.warn("Not expecting a sync.");
            return;
        }
        Request r = (Request)this.pendingSyncs.remove();
        this.commitProcessor.commit(r);
    }

    public String getState() {
        return "observer";
    }
}

