/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bk_v4_2_0.bookkeeper.server.quorum;

import java.io.IOException;
import org.apache.bk_v4_2_0.bookkeeper.KeeperException;
import org.apache.bk_v4_2_0.bookkeeper.jmx.MBeanRegistry;
import org.apache.bk_v4_2_0.bookkeeper.server.DataTreeBean;
import org.apache.bk_v4_2_0.bookkeeper.server.FinalRequestProcessor;
import org.apache.bk_v4_2_0.bookkeeper.server.PrepRequestProcessor;
import org.apache.bk_v4_2_0.bookkeeper.server.ServerCnxn;
import org.apache.bk_v4_2_0.bookkeeper.server.SessionTrackerImpl;
import org.apache.bk_v4_2_0.bookkeeper.server.ZKDatabase;
import org.apache.bk_v4_2_0.bookkeeper.server.ZooKeeperServer;
import org.apache.bk_v4_2_0.bookkeeper.server.persistence.FileTxnSnapLog;
import org.apache.bk_v4_2_0.bookkeeper.server.quorum.CommitProcessor;
import org.apache.bk_v4_2_0.bookkeeper.server.quorum.Leader;
import org.apache.bk_v4_2_0.bookkeeper.server.quorum.LeaderBean;
import org.apache.bk_v4_2_0.bookkeeper.server.quorum.LocalPeerBean;
import org.apache.bk_v4_2_0.bookkeeper.server.quorum.ProposalRequestProcessor;
import org.apache.bk_v4_2_0.bookkeeper.server.quorum.QuorumPeer;
import org.apache.bk_v4_2_0.bookkeeper.server.quorum.QuorumZooKeeperServer;

public class LeaderZooKeeperServer
extends QuorumZooKeeperServer {
    CommitProcessor commitProcessor;

    LeaderZooKeeperServer(FileTxnSnapLog logFactory, QuorumPeer self, ZooKeeperServer.DataTreeBuilder treeBuilder, ZKDatabase zkDb) throws IOException {
        super(logFactory, self.tickTime, self.minSessionTimeout, self.maxSessionTimeout, treeBuilder, zkDb, self);
    }

    public Leader getLeader() {
        return this.self.leader;
    }

    protected void setupRequestProcessors() {
        FinalRequestProcessor finalProcessor = new FinalRequestProcessor(this);
        Leader.ToBeAppliedRequestProcessor toBeAppliedProcessor = new Leader.ToBeAppliedRequestProcessor(finalProcessor, this.getLeader().toBeApplied);
        this.commitProcessor = new CommitProcessor(toBeAppliedProcessor, Long.toString(this.getServerId()), false);
        this.commitProcessor.start();
        ProposalRequestProcessor proposalProcessor = new ProposalRequestProcessor(this, this.commitProcessor);
        proposalProcessor.initialize();
        this.firstProcessor = new PrepRequestProcessor(this, proposalProcessor);
        ((PrepRequestProcessor)this.firstProcessor).start();
    }

    public int getGlobalOutstandingLimit() {
        return super.getGlobalOutstandingLimit() / (this.self.getQuorumSize() - 1);
    }

    public void createSessionTracker() {
        this.sessionTracker = new SessionTrackerImpl(this, this.getZKDatabase().getSessionWithTimeOuts(), this.tickTime, this.self.getId());
    }

    protected void startSessionTracker() {
        ((SessionTrackerImpl)this.sessionTracker).start();
    }

    public boolean touch(long sess, int to) {
        return this.sessionTracker.touchSession(sess, to);
    }

    protected void registerJMX() {
        try {
            this.jmxDataTreeBean = new DataTreeBean(this.getZKDatabase().getDataTree());
            MBeanRegistry.getInstance().register(this.jmxDataTreeBean, this.jmxServerBean);
        }
        catch (Exception e) {
            LOG.warn("Failed to register with JMX", (Throwable)e);
            this.jmxDataTreeBean = null;
        }
    }

    public void registerJMX(LeaderBean leaderBean, LocalPeerBean localPeerBean) {
        if (this.self.jmxLeaderElectionBean != null) {
            try {
                MBeanRegistry.getInstance().unregister(this.self.jmxLeaderElectionBean);
            }
            catch (Exception e) {
                LOG.warn("Failed to register with JMX", (Throwable)e);
            }
            this.self.jmxLeaderElectionBean = null;
        }
        try {
            this.jmxServerBean = leaderBean;
            MBeanRegistry.getInstance().register(leaderBean, localPeerBean);
        }
        catch (Exception e) {
            LOG.warn("Failed to register with JMX", (Throwable)e);
            this.jmxServerBean = null;
        }
    }

    protected void unregisterJMX() {
        try {
            if (this.jmxDataTreeBean != null) {
                MBeanRegistry.getInstance().unregister(this.jmxDataTreeBean);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to unregister with JMX", (Throwable)e);
        }
        this.jmxDataTreeBean = null;
    }

    protected void unregisterJMX(Leader leader) {
        try {
            if (this.jmxServerBean != null) {
                MBeanRegistry.getInstance().unregister(this.jmxServerBean);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to unregister with JMX", (Throwable)e);
        }
        this.jmxServerBean = null;
    }

    public String getState() {
        return "leader";
    }

    public long getServerId() {
        return this.self.getId();
    }

    protected void revalidateSession(ServerCnxn cnxn, long sessionId, int sessionTimeout) throws IOException {
        super.revalidateSession(cnxn, sessionId, sessionTimeout);
        try {
            this.setOwner(sessionId, ServerCnxn.me);
        }
        catch (KeeperException.SessionExpiredException e) {
            // empty catch block
        }
    }
}

