/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bk_v4_2_0.bookkeeper.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.HashMap;
import javax.management.JMException;
import org.apache.bk_v4_2_0.bookkeeper.Login;
import org.apache.bk_v4_2_0.bookkeeper.jmx.MBeanRegistry;
import org.apache.bk_v4_2_0.bookkeeper.server.ConnectionBean;
import org.apache.bk_v4_2_0.bookkeeper.server.NIOServerCnxnFactory;
import org.apache.bk_v4_2_0.bookkeeper.server.ServerCnxn;
import org.apache.bk_v4_2_0.bookkeeper.server.ZooKeeperServer;
import org.apache.bk_v4_2_0.bookkeeper.server.auth.SaslServerCallbackHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServerCnxnFactory {
    public static final String ZOOKEEPER_SERVER_CNXN_FACTORY = "zookeeper.serverCnxnFactory";
    Logger LOG = LoggerFactory.getLogger(ServerCnxnFactory.class);
    static final ByteBuffer closeConn = ByteBuffer.allocate(0);
    protected SaslServerCallbackHandler saslServerCallbackHandler;
    public Login login;
    protected ZooKeeperServer zkServer;
    private HashMap<ServerCnxn, ConnectionBean> connectionBeans = new HashMap();

    public abstract int getLocalPort();

    public abstract Iterable<ServerCnxn> getConnections();

    public abstract void closeSession(long var1);

    public abstract void configure(InetSocketAddress var1, int var2) throws IOException;

    public abstract int getMaxClientCnxnsPerHost();

    public abstract void setMaxClientCnxnsPerHost(int var1);

    public abstract void startup(ZooKeeperServer var1) throws IOException, InterruptedException;

    public abstract void join() throws InterruptedException;

    public abstract void shutdown();

    public abstract void start();

    public final void setZooKeeperServer(ZooKeeperServer zk) {
        this.zkServer = zk;
        if (zk != null) {
            zk.setServerCnxnFactory(this);
        }
    }

    public abstract void closeAll();

    public static ServerCnxnFactory createFactory() throws IOException {
        String serverCnxnFactoryName = System.getProperty(ZOOKEEPER_SERVER_CNXN_FACTORY);
        if (serverCnxnFactoryName == null) {
            serverCnxnFactoryName = NIOServerCnxnFactory.class.getName();
        }
        try {
            return (ServerCnxnFactory)Class.forName(serverCnxnFactoryName).newInstance();
        }
        catch (Exception e) {
            IOException ioe = new IOException("Couldn't instantiate " + serverCnxnFactoryName);
            ioe.initCause(e);
            throw ioe;
        }
    }

    public static ServerCnxnFactory createFactory(int clientPort, int maxClientCnxns) throws IOException {
        return ServerCnxnFactory.createFactory(new InetSocketAddress(clientPort), maxClientCnxns);
    }

    public static ServerCnxnFactory createFactory(InetSocketAddress addr, int maxClientCnxns) throws IOException {
        ServerCnxnFactory factory = ServerCnxnFactory.createFactory();
        factory.configure(addr, maxClientCnxns);
        return factory;
    }

    public abstract InetSocketAddress getLocalAddress();

    public void unregisterConnection(ServerCnxn serverCnxn) {
        ConnectionBean jmxConnectionBean = this.connectionBeans.remove(serverCnxn);
        if (jmxConnectionBean != null) {
            MBeanRegistry.getInstance().unregister(jmxConnectionBean);
        }
    }

    public void registerConnection(ServerCnxn serverCnxn) {
        if (this.zkServer != null) {
            ConnectionBean jmxConnectionBean = new ConnectionBean(serverCnxn, this.zkServer);
            try {
                MBeanRegistry.getInstance().register(jmxConnectionBean, this.zkServer.jmxServerBean);
                this.connectionBeans.put(serverCnxn, jmxConnectionBean);
            }
            catch (JMException e) {
                this.LOG.warn("Could not register connection", (Throwable)e);
            }
        }
    }

    public static interface PacketProcessor {
        public void processPacket(ByteBuffer var1, ServerCnxn var2);
    }
}

