/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bk_v4_2_0.bookkeeper.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executors;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginException;
import org.apache.bk_v4_2_0.bookkeeper.Login;
import org.apache.bk_v4_2_0.bookkeeper.server.NettyServerCnxn;
import org.apache.bk_v4_2_0.bookkeeper.server.ServerCnxn;
import org.apache.bk_v4_2_0.bookkeeper.server.ServerCnxnFactory;
import org.apache.bk_v4_2_0.bookkeeper.server.ZooKeeperServer;
import org.apache.bk_v4_2_0.bookkeeper.server.auth.SaslServerCallbackHandler;
import org.jboss.bk_v4_2_0.netty.bootstrap.ServerBootstrap;
import org.jboss.bk_v4_2_0.netty.buffer.ChannelBuffer;
import org.jboss.bk_v4_2_0.netty.buffer.ChannelBuffers;
import org.jboss.bk_v4_2_0.netty.channel.Channel;
import org.jboss.bk_v4_2_0.netty.channel.ChannelHandler;
import org.jboss.bk_v4_2_0.netty.channel.ChannelHandlerContext;
import org.jboss.bk_v4_2_0.netty.channel.ChannelStateEvent;
import org.jboss.bk_v4_2_0.netty.channel.ExceptionEvent;
import org.jboss.bk_v4_2_0.netty.channel.MessageEvent;
import org.jboss.bk_v4_2_0.netty.channel.SimpleChannelHandler;
import org.jboss.bk_v4_2_0.netty.channel.WriteCompletionEvent;
import org.jboss.bk_v4_2_0.netty.channel.group.ChannelGroup;
import org.jboss.bk_v4_2_0.netty.channel.group.DefaultChannelGroup;
import org.jboss.bk_v4_2_0.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NettyServerCnxnFactory
extends ServerCnxnFactory {
    Logger LOG = LoggerFactory.getLogger(NettyServerCnxnFactory.class);
    ServerBootstrap bootstrap;
    Channel parentChannel;
    ChannelGroup allChannels = new DefaultChannelGroup("zkServerCnxns");
    HashSet<ServerCnxn> cnxns = new HashSet();
    HashMap<InetAddress, Set<NettyServerCnxn>> ipMap = new HashMap();
    InetSocketAddress localAddress;
    int maxClientCnxns = 60;
    CnxnChannelHandler channelHandler = new CnxnChannelHandler();
    boolean killed;

    NettyServerCnxnFactory() {
        this.bootstrap = new ServerBootstrap(new NioServerSocketChannelFactory(Executors.newCachedThreadPool(), Executors.newCachedThreadPool()));
        this.bootstrap.setOption("reuseAddress", true);
        this.bootstrap.setOption("child.tcpNoDelay", true);
        this.bootstrap.setOption("child.soLinger", 2);
        this.bootstrap.getPipeline().addLast("servercnxnfactory", this.channelHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeAll() {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("closeAll()");
        }
        HashSet<ServerCnxn> hashSet = this.cnxns;
        synchronized (hashSet) {
            for (NettyServerCnxn cnxn : this.cnxns.toArray(new NettyServerCnxn[this.cnxns.size()])) {
                try {
                    cnxn.close();
                }
                catch (Exception e) {
                    this.LOG.warn("Ignoring exception closing cnxn sessionid 0x" + Long.toHexString(cnxn.getSessionId()), (Throwable)e);
                }
            }
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("allChannels size:" + this.allChannels.size() + " cnxns size:" + this.cnxns.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeSession(long sessionId) {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("closeSession sessionid:0x" + sessionId);
        }
        HashSet<ServerCnxn> hashSet = this.cnxns;
        synchronized (hashSet) {
            for (NettyServerCnxn cnxn : this.cnxns.toArray(new NettyServerCnxn[this.cnxns.size()])) {
                if (cnxn.getSessionId() != sessionId) continue;
                try {
                    cnxn.close();
                }
                catch (Exception e) {
                    this.LOG.warn("exception during session close", (Throwable)e);
                }
                break;
            }
        }
    }

    @Override
    public void configure(InetSocketAddress addr, int maxClientCnxns) throws IOException {
        if (System.getProperty("java.security.auth.login.config") != null) {
            try {
                this.saslServerCallbackHandler = new SaslServerCallbackHandler(Configuration.getConfiguration());
                this.login = new Login("Server", this.saslServerCallbackHandler);
                this.login.startThreadIfNeeded();
            }
            catch (LoginException e) {
                throw new IOException("Could not configure server because SASL configuration did not allow the  Zookeeper server to authenticate itself properly: " + e);
            }
        }
        this.localAddress = addr;
        this.maxClientCnxns = maxClientCnxns;
    }

    @Override
    public int getMaxClientCnxnsPerHost() {
        return this.maxClientCnxns;
    }

    @Override
    public void setMaxClientCnxnsPerHost(int max) {
        this.maxClientCnxns = max;
    }

    @Override
    public int getLocalPort() {
        return this.localAddress.getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void join() throws InterruptedException {
        NettyServerCnxnFactory nettyServerCnxnFactory = this;
        synchronized (nettyServerCnxnFactory) {
            while (!this.killed) {
                this.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        this.LOG.info("shutdown called " + this.localAddress);
        if (this.login != null) {
            this.login.shutdown();
        }
        if (this.parentChannel != null) {
            this.parentChannel.close().awaitUninterruptibly();
            this.closeAll();
            this.allChannels.close().awaitUninterruptibly();
            this.bootstrap.releaseExternalResources();
        }
        if (this.zkServer != null) {
            this.zkServer.shutdown();
        }
        NettyServerCnxnFactory nettyServerCnxnFactory = this;
        synchronized (nettyServerCnxnFactory) {
            this.killed = true;
            this.notifyAll();
        }
    }

    @Override
    public void start() {
        this.LOG.info("binding to port " + this.localAddress);
        this.parentChannel = this.bootstrap.bind(this.localAddress);
    }

    @Override
    public void startup(ZooKeeperServer zks) throws IOException, InterruptedException {
        this.start();
        zks.startdata();
        zks.startup();
        this.setZooKeeperServer(zks);
    }

    @Override
    public Iterable<ServerCnxn> getConnections() {
        return this.cnxns;
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return this.localAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCnxn(NettyServerCnxn cnxn) {
        HashSet<ServerCnxn> hashSet = this.cnxns;
        synchronized (hashSet) {
            this.cnxns.add(cnxn);
            HashMap<InetAddress, Set<NettyServerCnxn>> hashMap = this.ipMap;
            synchronized (hashMap) {
                InetAddress addr = ((InetSocketAddress)cnxn.channel.getRemoteAddress()).getAddress();
                Set<NettyServerCnxn> s = this.ipMap.get(addr);
                if (s == null) {
                    s = new HashSet<NettyServerCnxn>();
                }
                s.add(cnxn);
                this.ipMap.put(addr, s);
            }
        }
    }

    @ChannelHandler.Sharable
    class CnxnChannelHandler
    extends SimpleChannelHandler {
        CnxnChannelHandler() {
        }

        public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
            if (NettyServerCnxnFactory.this.LOG.isTraceEnabled()) {
                NettyServerCnxnFactory.this.LOG.trace("Channel closed " + e);
            }
            NettyServerCnxnFactory.this.allChannels.remove(ctx.getChannel());
        }

        public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
            if (NettyServerCnxnFactory.this.LOG.isTraceEnabled()) {
                NettyServerCnxnFactory.this.LOG.trace("Channel connected " + e);
            }
            NettyServerCnxnFactory.this.allChannels.add(ctx.getChannel());
            NettyServerCnxn cnxn = new NettyServerCnxn(ctx.getChannel(), NettyServerCnxnFactory.this.zkServer, NettyServerCnxnFactory.this);
            ctx.setAttachment(cnxn);
            NettyServerCnxnFactory.this.addCnxn(cnxn);
        }

        public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
            NettyServerCnxn cnxn;
            if (NettyServerCnxnFactory.this.LOG.isTraceEnabled()) {
                NettyServerCnxnFactory.this.LOG.trace("Channel disconnected " + e);
            }
            if ((cnxn = (NettyServerCnxn)ctx.getAttachment()) != null) {
                if (NettyServerCnxnFactory.this.LOG.isTraceEnabled()) {
                    NettyServerCnxnFactory.this.LOG.trace("Channel disconnect caused close " + e);
                }
                cnxn.close();
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
            NettyServerCnxnFactory.this.LOG.warn("Exception caught " + e, e.getCause());
            NettyServerCnxn cnxn = (NettyServerCnxn)ctx.getAttachment();
            if (cnxn != null && NettyServerCnxnFactory.this.LOG.isDebugEnabled()) {
                NettyServerCnxnFactory.this.LOG.debug("Closing " + cnxn);
                cnxn.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
            if (NettyServerCnxnFactory.this.LOG.isTraceEnabled()) {
                NettyServerCnxnFactory.this.LOG.trace("message received called " + e.getMessage());
            }
            try {
                NettyServerCnxn cnxn;
                if (NettyServerCnxnFactory.this.LOG.isDebugEnabled()) {
                    NettyServerCnxnFactory.this.LOG.debug("New message " + e.toString() + " from " + ctx.getChannel());
                }
                NettyServerCnxn nettyServerCnxn = cnxn = (NettyServerCnxn)ctx.getAttachment();
                synchronized (nettyServerCnxn) {
                    this.processMessage(e, cnxn);
                }
            }
            catch (Exception ex) {
                NettyServerCnxnFactory.this.LOG.error("Unexpected exception in receive", (Throwable)ex);
                throw ex;
            }
        }

        private void processMessage(MessageEvent e, NettyServerCnxn cnxn) {
            if (NettyServerCnxnFactory.this.LOG.isDebugEnabled()) {
                NettyServerCnxnFactory.this.LOG.debug(Long.toHexString(cnxn.sessionId) + " queuedBuffer: " + cnxn.queuedBuffer);
            }
            if (e instanceof NettyServerCnxn.ResumeMessageEvent) {
                NettyServerCnxnFactory.this.LOG.debug("Received ResumeMessageEvent");
                if (cnxn.queuedBuffer != null) {
                    if (NettyServerCnxnFactory.this.LOG.isTraceEnabled()) {
                        NettyServerCnxnFactory.this.LOG.trace("processing queue " + Long.toHexString(cnxn.sessionId) + " queuedBuffer 0x" + ChannelBuffers.hexDump(cnxn.queuedBuffer));
                    }
                    cnxn.receiveMessage(cnxn.queuedBuffer);
                    if (!cnxn.queuedBuffer.readable()) {
                        NettyServerCnxnFactory.this.LOG.debug("Processed queue - no bytes remaining");
                        cnxn.queuedBuffer = null;
                    } else {
                        NettyServerCnxnFactory.this.LOG.debug("Processed queue - bytes remaining");
                    }
                } else {
                    NettyServerCnxnFactory.this.LOG.debug("queue empty");
                }
                cnxn.channel.setReadable(true);
            } else {
                ChannelBuffer buf = (ChannelBuffer)e.getMessage();
                if (NettyServerCnxnFactory.this.LOG.isTraceEnabled()) {
                    NettyServerCnxnFactory.this.LOG.trace(Long.toHexString(cnxn.sessionId) + " buf 0x" + ChannelBuffers.hexDump(buf));
                }
                if (cnxn.throttled) {
                    NettyServerCnxnFactory.this.LOG.debug("Received message while throttled");
                    if (cnxn.queuedBuffer == null) {
                        NettyServerCnxnFactory.this.LOG.debug("allocating queue");
                        cnxn.queuedBuffer = ChannelBuffers.dynamicBuffer(buf.readableBytes());
                    }
                    cnxn.queuedBuffer.writeBytes(buf);
                    NettyServerCnxnFactory.this.LOG.debug(Long.toHexString(cnxn.sessionId) + " queuedBuffer 0x" + ChannelBuffers.hexDump(cnxn.queuedBuffer));
                } else {
                    NettyServerCnxnFactory.this.LOG.debug("not throttled");
                    if (cnxn.queuedBuffer != null) {
                        if (NettyServerCnxnFactory.this.LOG.isTraceEnabled()) {
                            NettyServerCnxnFactory.this.LOG.trace(Long.toHexString(cnxn.sessionId) + " queuedBuffer 0x" + ChannelBuffers.hexDump(cnxn.queuedBuffer));
                        }
                        cnxn.queuedBuffer.writeBytes(buf);
                        if (NettyServerCnxnFactory.this.LOG.isTraceEnabled()) {
                            NettyServerCnxnFactory.this.LOG.trace(Long.toHexString(cnxn.sessionId) + " queuedBuffer 0x" + ChannelBuffers.hexDump(cnxn.queuedBuffer));
                        }
                        cnxn.receiveMessage(cnxn.queuedBuffer);
                        if (!cnxn.queuedBuffer.readable()) {
                            NettyServerCnxnFactory.this.LOG.debug("Processed queue - no bytes remaining");
                            cnxn.queuedBuffer = null;
                        } else {
                            NettyServerCnxnFactory.this.LOG.debug("Processed queue - bytes remaining");
                        }
                    } else {
                        cnxn.receiveMessage(buf);
                        if (buf.readable()) {
                            if (NettyServerCnxnFactory.this.LOG.isTraceEnabled()) {
                                NettyServerCnxnFactory.this.LOG.trace("Before copy " + buf);
                            }
                            cnxn.queuedBuffer = ChannelBuffers.dynamicBuffer(buf.readableBytes());
                            cnxn.queuedBuffer.writeBytes(buf);
                            if (NettyServerCnxnFactory.this.LOG.isTraceEnabled()) {
                                NettyServerCnxnFactory.this.LOG.trace("Copy is " + cnxn.queuedBuffer);
                                NettyServerCnxnFactory.this.LOG.trace(Long.toHexString(cnxn.sessionId) + " queuedBuffer 0x" + ChannelBuffers.hexDump(cnxn.queuedBuffer));
                            }
                        }
                    }
                }
            }
        }

        public void writeComplete(ChannelHandlerContext ctx, WriteCompletionEvent e) throws Exception {
            if (NettyServerCnxnFactory.this.LOG.isTraceEnabled()) {
                NettyServerCnxnFactory.this.LOG.trace("write complete " + e);
            }
        }
    }
}

