/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bk_v4_2_0.bookkeeper.replication;

import bk-shade.com.google.proto_bk_v4_2_0.TextFormat;
import com.google.bk_v4_2_0.common.annotations.VisibleForTesting;
import com.google.bk_v4_2_0.common.base.Charsets;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.bk_v4_2_0.bookkeeper.CreateMode;
import org.apache.bk_v4_2_0.bookkeeper.KeeperException;
import org.apache.bk_v4_2_0.bookkeeper.WatchedEvent;
import org.apache.bk_v4_2_0.bookkeeper.Watcher;
import org.apache.bk_v4_2_0.bookkeeper.ZooDefs;
import org.apache.bk_v4_2_0.bookkeeper.ZooKeeper;
import org.apache.bk_v4_2_0.bookkeeper.conf.ServerConfiguration;
import org.apache.bk_v4_2_0.bookkeeper.proto.DataFormats;
import org.apache.bk_v4_2_0.bookkeeper.replication.Auditor;
import org.apache.bk_v4_2_0.bookkeeper.replication.ReplicationException;
import org.apache.bk_v4_2_0.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditorElector {
    private static final Logger LOG = LoggerFactory.getLogger(AuditorElector.class);
    private static final int AUDITOR_INDEX = 0;
    private static final String VOTE_PREFIX = "V_";
    private static final String PATH_SEPARATOR = "/";
    private final String basePath;
    private final String electionPath;
    private final String bookieId;
    private final ServerConfiguration conf;
    private final ZooKeeper zkc;
    private final ExecutorService executor;
    private String myVote;
    Auditor auditor;
    private AtomicBoolean running = new AtomicBoolean(false);

    public AuditorElector(final String bookieId, ServerConfiguration conf, ZooKeeper zkc) throws ReplicationException.UnavailableException {
        this.bookieId = bookieId;
        this.conf = conf;
        this.zkc = zkc;
        this.basePath = conf.getZkLedgersRootPath() + '/' + "underreplication";
        this.electionPath = this.basePath + "/auditorelection";
        this.createElectorPath();
        this.executor = Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "AuditorElector-" + bookieId);
            }
        });
    }

    private void createMyVote() throws KeeperException, InterruptedException {
        if (null == this.myVote || null == this.zkc.exists(this.myVote, false)) {
            DataFormats.AuditorVoteFormat.Builder builder = DataFormats.AuditorVoteFormat.newBuilder().setBookieId(this.bookieId);
            this.myVote = this.zkc.create(this.getVotePath("/V_"), TextFormat.printToString(builder.build()).getBytes(Charsets.UTF_8), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
        }
    }

    private String getVotePath(String vote) {
        return this.electionPath + vote;
    }

    private void createElectorPath() throws ReplicationException.UnavailableException {
        try {
            if (this.zkc.exists(this.basePath, false) == null) {
                try {
                    this.zkc.create(this.basePath, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                }
                catch (KeeperException.NodeExistsException nee) {
                    // empty catch block
                }
            }
            if (this.zkc.exists(this.getVotePath(""), false) == null) {
                try {
                    this.zkc.create(this.getVotePath(""), new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                }
                catch (KeeperException.NodeExistsException nee) {}
            }
        }
        catch (KeeperException ke) {
            throw new ReplicationException.UnavailableException("Failed to initialize Auditor Elector", ke);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new ReplicationException.UnavailableException("Failed to initialize Auditor Elector", ie);
        }
    }

    public void start() {
        this.running.set(true);
        this.submitElectionTask();
    }

    private void submitShutdownTask() {
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                if (!AuditorElector.this.running.compareAndSet(true, false)) {
                    return;
                }
                LOG.info("Shutting down AuditorElector");
                if (AuditorElector.this.myVote != null) {
                    try {
                        AuditorElector.this.zkc.delete(AuditorElector.this.myVote, -1);
                    }
                    catch (InterruptedException ie) {
                        LOG.warn("InterruptedException while deleting myVote: " + AuditorElector.this.myVote, (Throwable)ie);
                    }
                    catch (KeeperException ke) {
                        LOG.error("Exception while deleting myVote:" + AuditorElector.this.myVote, (Throwable)ke);
                    }
                }
            }
        });
    }

    @VisibleForTesting
    void submitElectionTask() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    AuditorElector.this.createMyVote();
                    List<String> children = AuditorElector.this.zkc.getChildren(AuditorElector.this.getVotePath(""), false);
                    if (0 >= children.size()) {
                        throw new IllegalArgumentException("Atleast one bookie server should present to elect the Auditor!");
                    }
                    Collections.sort(children, new ElectionComparator());
                    String voteNode = StringUtils.substringAfterLast(AuditorElector.this.myVote, AuditorElector.PATH_SEPARATOR);
                    if (children.get(0).equals(voteNode)) {
                        DataFormats.AuditorVoteFormat.Builder builder = DataFormats.AuditorVoteFormat.newBuilder().setBookieId(AuditorElector.this.bookieId);
                        AuditorElector.this.zkc.setData(AuditorElector.this.getVotePath(""), TextFormat.printToString(builder.build()).getBytes(Charsets.UTF_8), -1);
                        AuditorElector.this.auditor = new Auditor(AuditorElector.this.bookieId, AuditorElector.this.conf, AuditorElector.this.zkc);
                        AuditorElector.this.auditor.start();
                    } else {
                        ElectionWatcher electionWatcher = new ElectionWatcher();
                        int myIndex = children.indexOf(voteNode);
                        int prevNodeIndex = myIndex - 1;
                        if (null == AuditorElector.this.zkc.exists(AuditorElector.this.getVotePath(AuditorElector.PATH_SEPARATOR) + children.get(prevNodeIndex), electionWatcher)) {
                            AuditorElector.this.submitElectionTask();
                        }
                    }
                }
                catch (KeeperException e) {
                    LOG.error("Exception while performing auditor election", (Throwable)e);
                    AuditorElector.this.submitShutdownTask();
                }
                catch (InterruptedException e) {
                    LOG.error("Interrupted while performing auditor election", (Throwable)e);
                    Thread.currentThread().interrupt();
                    AuditorElector.this.submitShutdownTask();
                }
                catch (ReplicationException.UnavailableException e) {
                    LOG.error("Ledger underreplication manager unavailable during election", (Throwable)e);
                    AuditorElector.this.submitShutdownTask();
                }
            }
        };
        this.executor.submit(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws InterruptedException {
        AuditorElector auditorElector = this;
        synchronized (auditorElector) {
            if (this.executor.isShutdown()) {
                return;
            }
            this.submitShutdownTask();
            this.executor.shutdown();
        }
        if (this.auditor != null) {
            this.auditor.shutdown();
            this.auditor = null;
        }
    }

    public boolean isRunning() {
        if (this.auditor != null) {
            return this.auditor.isRunning();
        }
        return this.running.get();
    }

    private static class ElectionComparator
    implements Comparator<String>,
    Serializable {
        private ElectionComparator() {
        }

        @Override
        public int compare(String vote1, String vote2) {
            long voteSeqId2;
            long voteSeqId1 = this.getVoteSequenceId(vote1);
            int result = voteSeqId1 < (voteSeqId2 = this.getVoteSequenceId(vote2)) ? -1 : (voteSeqId1 > voteSeqId2 ? 1 : 0);
            return result;
        }

        private long getVoteSequenceId(String vote) {
            String voteId = StringUtils.substringAfter(vote, AuditorElector.VOTE_PREFIX);
            return Long.parseLong(voteId);
        }
    }

    private class ElectionWatcher
    implements Watcher {
        private ElectionWatcher() {
        }

        @Override
        public void process(WatchedEvent event) {
            if (event.getState() == Watcher.Event.KeeperState.Disconnected || event.getState() == Watcher.Event.KeeperState.Expired) {
                LOG.error("Lost ZK connection, shutting down");
                AuditorElector.this.submitShutdownTask();
            } else if (event.getType() == Watcher.Event.EventType.NodeDeleted) {
                AuditorElector.this.submitElectionTask();
            }
        }
    }
}

