/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bk_v4_2_0.bookkeeper.proto;

import com.google.bk_v4_2_0.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.bk_v4_2_0.bookkeeper.KeeperException;
import org.apache.bk_v4_2_0.bookkeeper.bookie.Bookie;
import org.apache.bk_v4_2_0.bookkeeper.bookie.BookieException;
import org.apache.bk_v4_2_0.bookkeeper.conf.ServerConfiguration;
import org.apache.bk_v4_2_0.bookkeeper.jmx.BKMBeanRegistry;
import org.apache.bk_v4_2_0.bookkeeper.proto.BKStats;
import org.apache.bk_v4_2_0.bookkeeper.proto.BookieProtocol;
import org.apache.bk_v4_2_0.bookkeeper.proto.BookieServerBean;
import org.apache.bk_v4_2_0.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bk_v4_2_0.bookkeeper.proto.NIOServerFactory;
import org.apache.bk_v4_2_0.bookkeeper.replication.AutoRecoveryMain;
import org.apache.bk_v4_2_0.bookkeeper.replication.ReplicationException;
import org.apache.bk_v4_2_0.bookkeeper.util.MathUtils;
import org.apache.bk_v4_2_0.commons.cli.BasicParser;
import org.apache.bk_v4_2_0.commons.cli.CommandLine;
import org.apache.bk_v4_2_0.commons.cli.HelpFormatter;
import org.apache.bk_v4_2_0.commons.cli.Options;
import org.apache.bk_v4_2_0.commons.cli.ParseException;
import org.apache.bk_v4_2_0.commons.codec.binary.Hex;
import org.apache.bk_v4_2_0.commons.configuration.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookieServer
implements NIOServerFactory.PacketProcessor,
BookkeeperInternalCallbacks.WriteCallback {
    final ServerConfiguration conf;
    NIOServerFactory nioServerFactory;
    private volatile boolean running = false;
    Bookie bookie;
    DeathWatcher deathWatcher;
    static Logger LOG = LoggerFactory.getLogger(BookieServer.class);
    int exitCode = 0;
    final BKStats bkStats = BKStats.getInstance();
    final boolean isStatsEnabled;
    protected BookieServerBean jmxBkServerBean;
    private AutoRecoveryMain autoRecoveryMain = null;
    private boolean isAutoRecoveryDaemonEnabled;
    static final Options bkOpts = new Options();

    public BookieServer(ServerConfiguration conf) throws IOException, KeeperException, InterruptedException, BookieException, ReplicationException.UnavailableException, ReplicationException.CompatibilityException {
        this.conf = conf;
        this.bookie = this.newBookie(conf);
        this.isAutoRecoveryDaemonEnabled = conf.isAutoRecoveryDaemonEnabled();
        if (this.isAutoRecoveryDaemonEnabled) {
            this.autoRecoveryMain = new AutoRecoveryMain(conf);
        }
        this.isStatsEnabled = conf.isStatisticsEnabled();
    }

    protected Bookie newBookie(ServerConfiguration conf) throws IOException, KeeperException, InterruptedException, BookieException {
        return new Bookie(conf);
    }

    public void start() throws IOException, ReplicationException.UnavailableException {
        this.nioServerFactory = new NIOServerFactory(this.conf, this);
        this.bookie.start();
        if (this.isAutoRecoveryDaemonEnabled && this.autoRecoveryMain != null) {
            this.autoRecoveryMain.start();
        }
        this.nioServerFactory.start();
        this.running = true;
        this.deathWatcher = new DeathWatcher(this.conf);
        this.deathWatcher.start();
        this.registerJMX();
    }

    public InetSocketAddress getLocalAddress() {
        try {
            return Bookie.getBookieAddress(this.conf);
        }
        catch (UnknownHostException uhe) {
            return this.nioServerFactory.getLocalAddress();
        }
    }

    @VisibleForTesting
    public Bookie getBookie() {
        return this.bookie;
    }

    @VisibleForTesting
    public void suspendProcessing() {
        this.nioServerFactory.suspendProcessing();
    }

    @VisibleForTesting
    public void resumeProcessing() {
        this.nioServerFactory.resumeProcessing();
    }

    public synchronized void shutdown() {
        if (!this.running) {
            return;
        }
        this.nioServerFactory.shutdown();
        this.exitCode = this.bookie.shutdown();
        if (this.isAutoRecoveryDaemonEnabled && this.autoRecoveryMain != null) {
            this.autoRecoveryMain.shutdown();
        }
        this.running = false;
        this.unregisterJMX();
    }

    protected void registerJMX() {
        try {
            this.jmxBkServerBean = new BookieServerBean(this.conf, this);
            BKMBeanRegistry.getInstance().register(this.jmxBkServerBean, null);
            this.bookie.registerJMX(this.jmxBkServerBean);
        }
        catch (Exception e) {
            LOG.warn("Failed to register with JMX", (Throwable)e);
            this.jmxBkServerBean = null;
        }
    }

    protected void unregisterJMX() {
        try {
            this.bookie.unregisterJMX();
            if (this.jmxBkServerBean != null) {
                BKMBeanRegistry.getInstance().unregister(this.jmxBkServerBean);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to unregister with JMX", (Throwable)e);
        }
        this.jmxBkServerBean = null;
    }

    public boolean isRunning() {
        return this.bookie.isRunning() && this.nioServerFactory.isRunning() && this.running;
    }

    public boolean isBookieRunning() {
        return this.bookie.isRunning();
    }

    public boolean isAutoRecoveryRunning() {
        return this.autoRecoveryMain != null && this.autoRecoveryMain.isAutoRecoveryRunning();
    }

    public boolean isNioServerRunning() {
        return this.nioServerFactory.isRunning();
    }

    public void join() throws InterruptedException {
        this.nioServerFactory.join();
    }

    public int getExitCode() {
        return this.exitCode;
    }

    private static void printUsage() {
        HelpFormatter hf = new HelpFormatter();
        hf.printHelp("BookieServer [options]\n\tor\nBookieServer <bookie_port> <zk_servers> <journal_dir> <ledger_dir [ledger_dir]>", bkOpts);
    }

    private static void loadConfFile(ServerConfiguration conf, String confFile) throws IllegalArgumentException {
        try {
            conf.loadConf(new File(confFile).toURI().toURL());
        }
        catch (MalformedURLException e) {
            LOG.error("Could not open configuration file: " + confFile, (Throwable)e);
            throw new IllegalArgumentException();
        }
        catch (ConfigurationException e) {
            LOG.error("Malformed configuration file: " + confFile, (Throwable)e);
            throw new IllegalArgumentException();
        }
        LOG.info("Using configuration file " + confFile);
    }

    private static ServerConfiguration parseArgs(String[] args) throws IllegalArgumentException {
        try {
            BasicParser parser = new BasicParser();
            CommandLine cmdLine = parser.parse(bkOpts, args);
            if (cmdLine.hasOption('h')) {
                throw new IllegalArgumentException();
            }
            ServerConfiguration conf = new ServerConfiguration();
            String[] leftArgs = cmdLine.getArgs();
            if (cmdLine.hasOption('c')) {
                if (null != leftArgs && leftArgs.length > 0) {
                    throw new IllegalArgumentException();
                }
                String confFile = cmdLine.getOptionValue("c");
                BookieServer.loadConfFile(conf, confFile);
                return conf;
            }
            if (cmdLine.hasOption("withAutoRecovery")) {
                conf.setAutoRecoveryDaemonEnabled(true);
            }
            if (leftArgs.length < 4) {
                throw new IllegalArgumentException();
            }
            conf.setBookiePort(Integer.parseInt(leftArgs[0]));
            conf.setZkServers(leftArgs[1]);
            conf.setJournalDirName(leftArgs[2]);
            String[] ledgerDirNames = new String[leftArgs.length - 3];
            System.arraycopy(leftArgs, 3, ledgerDirNames, 0, ledgerDirNames.length);
            conf.setLedgerDirNames(ledgerDirNames);
            return conf;
        }
        catch (ParseException e) {
            LOG.error("Error parsing command line arguments : ", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }

    public static void main(String[] args) {
        ServerConfiguration conf = null;
        try {
            conf = BookieServer.parseArgs(args);
        }
        catch (IllegalArgumentException iae) {
            LOG.error("Error parsing command line arguments : ", (Throwable)iae);
            System.err.println(iae.getMessage());
            BookieServer.printUsage();
            System.exit(1);
        }
        StringBuilder sb = new StringBuilder();
        String[] ledgerDirNames = conf.getLedgerDirNames();
        for (int i = 0; i < ledgerDirNames.length; ++i) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append(ledgerDirNames[i]);
        }
        String hello = String.format("Hello, I'm your bookie, listening on port %1$s. ZKServers are on %2$s. Journals are in %3$s. Ledgers are stored in %4$s.", conf.getBookiePort(), conf.getZkServers(), conf.getJournalDirName(), sb);
        LOG.info(hello);
        try {
            final BookieServer bs = new BookieServer(conf);
            bs.start();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    bs.shutdown();
                    LOG.info("Shut down bookie server successfully");
                }
            });
            LOG.info("Register shutdown hook successfully");
            bs.join();
            System.exit(bs.getExitCode());
        }
        catch (Exception e) {
            LOG.error("Exception running bookie server : ", (Throwable)e);
            System.exit(2);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void processPacket(ByteBuffer packet, NIOServerFactory.Cnxn src) {
        h = BookieProtocol.PacketHeader.fromInt(packet.getInt());
        success = false;
        statType = 2;
        startTime = 0L;
        if (this.isStatsEnabled) {
            startTime = MathUtils.now();
        }
        ledgerId = -1L;
        entryId = -1L;
        masterKey = null;
        switch (h.getOpCode()) {
            case 1: {
                masterKey = new byte[20];
                packet.get(masterKey, 0, 20);
                bb = packet.duplicate();
                ledgerId = bb.getLong();
                entryId = bb.getLong();
                break;
            }
            case 2: {
                ledgerId = packet.getLong();
                entryId = packet.getLong();
            }
        }
        if (h.getVersion() < 0 || h.getVersion() > 2) {
            BookieServer.LOG.error("Invalid protocol version, expected something between 0 & 2. got " + h.getVersion());
            src.sendResponse(new ByteBuffer[]{this.buildResponse(103, h.getVersion(), h.getOpCode(), ledgerId, entryId)});
            return;
        }
        flags = h.getFlags();
        switch (h.getOpCode()) {
            case 1: {
                statType = 0;
                if (this.bookie.isReadOnly()) {
                    BookieServer.LOG.warn("BookieServer is running as readonly mode, so rejecting the request from the client!");
                    src.sendResponse(new ByteBuffer[]{this.buildResponse(105, h.getVersion(), h.getOpCode(), ledgerId, entryId)});
                    break;
                }
                try {
                    tsrc = new TimedCnxn(src, startTime);
                    if ((flags & 2) == 2) {
                        this.bookie.recoveryAddEntry(packet.slice(), this, tsrc, masterKey);
                    } else {
                        this.bookie.addEntry(packet.slice(), this, tsrc, masterKey);
                    }
                    success = true;
                }
                catch (IOException e) {
                    BookieServer.LOG.error("Error writing " + entryId + "@" + ledgerId, (Throwable)e);
                    src.sendResponse(new ByteBuffer[]{this.buildResponse(101, h.getVersion(), h.getOpCode(), ledgerId, entryId)});
                }
                catch (BookieException.LedgerFencedException lfe) {
                    BookieServer.LOG.error("Attempt to write to fenced ledger", (Throwable)lfe);
                    src.sendResponse(new ByteBuffer[]{this.buildResponse(104, h.getVersion(), h.getOpCode(), ledgerId, entryId)});
                }
                catch (BookieException e) {
                    BookieServer.LOG.error("Unauthorized access to ledger " + ledgerId, (Throwable)e);
                    src.sendResponse(new ByteBuffer[]{this.buildResponse(102, h.getVersion(), h.getOpCode(), ledgerId, entryId)});
                }
                break;
            }
            case 2: {
                statType = 1;
                rsp = new ByteBuffer[2];
                BookieServer.LOG.debug("Received new read request: {}, {}", (Object)ledgerId, (Object)entryId);
                errorCode = 101;
                try {
                    fenceResult = null;
                    if ((flags & 1) == 1) {
                        BookieServer.LOG.warn("Ledger " + ledgerId + " fenced by " + src.getPeerName());
                        if (h.getVersion() >= 2) {
                            masterKey = new byte[20];
                            packet.get(masterKey, 0, 20);
                            fenceResult = this.bookie.fenceLedger(ledgerId, masterKey);
                        } else {
                            BookieServer.LOG.error("Password not provided, Not safe to fence {}", (Object)ledgerId);
                            throw BookieException.create(-1);
                        }
                    }
                    rsp[1] = this.bookie.readEntry(ledgerId, entryId);
                    BookieServer.LOG.debug("##### Read entry ##### {}", (Object)rsp[1].remaining());
                    if (null == fenceResult) ** GOTO lbl102
                    try {
                        fenced = (Boolean)fenceResult.get(1000L, TimeUnit.MILLISECONDS);
                        if (null != fenced && fenced.booleanValue()) ** GOTO lbl81
                        errorCode = 101;
                        success = false;
                        rsp[1] = null;
                        ** GOTO lbl123
lbl81:
                        // 1 sources

                        errorCode = 0;
                        success = true;
                    }
                    catch (InterruptedException ie) {
                        BookieServer.LOG.error("Interrupting fence read entry (lid:" + ledgerId + ", eid:" + entryId + ") :", (Throwable)ie);
                        errorCode = 101;
                        success = false;
                        rsp[1] = null;
                    }
                    catch (ExecutionException ee) {
                        BookieServer.LOG.error("Failed to fence read entry (lid:" + ledgerId + ", eid:" + entryId + ") :", (Throwable)ee);
                        errorCode = 101;
                        success = false;
                        rsp[1] = null;
                    }
                    catch (TimeoutException te) {
                        BookieServer.LOG.error("Timeout to fence read entry (lid:" + ledgerId + ", eid:" + entryId + ") :", (Throwable)te);
                        errorCode = 101;
                        success = false;
                        rsp[1] = null;
                    }
                    ** GOTO lbl123
lbl102:
                    // 1 sources

                    errorCode = 0;
                    success = true;
                }
                catch (Bookie.NoLedgerException e) {
                    if (BookieServer.LOG.isTraceEnabled()) {
                        BookieServer.LOG.error("Error reading " + entryId + "@" + ledgerId, (Throwable)e);
                    }
                    errorCode = 1;
                }
                catch (Bookie.NoEntryException e) {
                    if (BookieServer.LOG.isTraceEnabled()) {
                        BookieServer.LOG.error("Error reading " + entryId + "@" + ledgerId, (Throwable)e);
                    }
                    errorCode = 2;
                }
                catch (IOException e) {
                    if (BookieServer.LOG.isTraceEnabled()) {
                        BookieServer.LOG.error("Error reading " + entryId + "@" + ledgerId, (Throwable)e);
                    }
                    errorCode = 101;
                }
                catch (BookieException e) {
                    BookieServer.LOG.error("Unauthorized access to ledger " + ledgerId, (Throwable)e);
                    errorCode = 102;
                }
lbl123:
                // 10 sources

                rsp[0] = this.buildResponse(errorCode, h.getVersion(), h.getOpCode(), ledgerId, entryId);
                if (BookieServer.LOG.isTraceEnabled()) {
                    BookieServer.LOG.trace("Read entry rc = " + errorCode + " for " + entryId + "@" + ledgerId);
                }
                if (rsp[1] == null) {
                    rsp[1] = ByteBuffer.allocate(16);
                    rsp[1].putLong(ledgerId);
                    rsp[1].putLong(entryId);
                    rsp[1].flip();
                }
                if (BookieServer.LOG.isTraceEnabled()) {
                    content = new byte[rsp[1].remaining()];
                    rsp[1].duplicate().get(content);
                    BookieServer.LOG.trace("Sending response for: {}, content: {}", (Object)entryId, (Object)Hex.encodeHexString(content));
                } else {
                    BookieServer.LOG.debug("Sending response for: {}, length: {}", (Object)entryId, (Object)rsp[1].remaining());
                }
                src.sendResponse(rsp);
                break;
            }
            default: {
                src.sendResponse(new ByteBuffer[]{this.buildResponse(100, h.getVersion(), h.getOpCode(), ledgerId, entryId)});
            }
        }
        if (this.isStatsEnabled) {
            if (success) {
                if (statType != 0) {
                    elapsedTime = MathUtils.now() - startTime;
                    this.bkStats.getOpStats(statType).updateLatency(elapsedTime);
                }
            } else {
                this.bkStats.getOpStats(statType).incrementFailedOps();
            }
        }
    }

    private ByteBuffer buildResponse(int errorCode, byte version, byte opCode, long ledgerId, long entryId) {
        ByteBuffer rsp = ByteBuffer.allocate(24);
        rsp.putInt(new BookieProtocol.PacketHeader(version, opCode, 0).toInt());
        rsp.putInt(errorCode);
        rsp.putLong(ledgerId);
        rsp.putLong(entryId);
        rsp.flip();
        return rsp;
    }

    @Override
    public void writeComplete(int rc, long ledgerId, long entryId, InetSocketAddress addr, Object ctx) {
        TimedCnxn tcnxn = (TimedCnxn)ctx;
        NIOServerFactory.Cnxn src = tcnxn.cnxn;
        long startTime = tcnxn.time;
        ByteBuffer bb = ByteBuffer.allocate(24);
        bb.putInt(new BookieProtocol.PacketHeader(2, 1, 0).toInt());
        bb.putInt(rc);
        bb.putLong(ledgerId);
        bb.putLong(entryId);
        bb.flip();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Add entry rc = " + rc + " for " + entryId + "@" + ledgerId);
        }
        src.sendResponse(bb);
        if (this.isStatsEnabled) {
            if (0 == rc) {
                long elapsedTime = MathUtils.now() - startTime;
                this.bkStats.getOpStats(0).updateLatency(elapsedTime);
            } else {
                this.bkStats.getOpStats(0).incrementFailedOps();
            }
        }
    }

    static {
        bkOpts.addOption("c", "conf", true, "Configuration for Bookie Server");
        bkOpts.addOption("withAutoRecovery", false, "Start Autorecovery service Bookie server");
        bkOpts.addOption("h", "help", false, "Print help message");
    }

    static class TimedCnxn {
        NIOServerFactory.Cnxn cnxn;
        long time;

        public TimedCnxn(NIOServerFactory.Cnxn cnxn, long startTime) {
            this.cnxn = cnxn;
            this.time = startTime;
        }
    }

    class DeathWatcher
    extends Thread {
        final int watchInterval;

        DeathWatcher(ServerConfiguration conf) {
            super("BookieDeathWatcher-" + conf.getBookiePort());
            this.watchInterval = conf.getDeathWatchInterval();
        }

        @Override
        public void run() {
            do {
                try {
                    Thread.sleep(this.watchInterval);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (BookieServer.this.isBookieRunning() && BookieServer.this.isNioServerRunning() && (!BookieServer.this.isAutoRecoveryDaemonEnabled || BookieServer.this.isAutoRecoveryRunning()));
            BookieServer.this.shutdown();
        }
    }
}

