/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bk_v4_2_0.bookkeeper.metastore;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.bk_v4_2_0.bookkeeper.metastore.InMemoryMetastoreTable;
import org.apache.bk_v4_2_0.bookkeeper.metastore.MSException;
import org.apache.bk_v4_2_0.bookkeeper.metastore.MetastoreCursor;
import org.apache.bk_v4_2_0.bookkeeper.metastore.MetastoreTableItem;
import org.apache.bk_v4_2_0.bookkeeper.metastore.Value;
import org.apache.bk_v4_2_0.bookkeeper.versioning.Versioned;

class InMemoryMetastoreCursor
implements MetastoreCursor {
    private final ScheduledExecutorService scheduler;
    private final Iterator<Map.Entry<String, Versioned<Value>>> iter;
    private final Set<String> fields;

    public InMemoryMetastoreCursor(NavigableMap<String, Versioned<Value>> map, Set<String> fields, ScheduledExecutorService scheduler) {
        this.iter = map.entrySet().iterator();
        this.fields = fields;
        this.scheduler = scheduler;
    }

    @Override
    public boolean hasMoreEntries() {
        return this.iter.hasNext();
    }

    @Override
    public Iterator<MetastoreTableItem> readEntries(int numEntries) throws MSException {
        if (numEntries < 0) {
            throw MSException.create(MSException.Code.IllegalOp);
        }
        return this.unsafeReadEntries(numEntries);
    }

    @Override
    public void asyncReadEntries(final int numEntries, final MetastoreCursor.ReadEntriesCallback cb, final Object ctx) {
        this.scheduler.submit(new Runnable(){

            @Override
            public void run() {
                if (numEntries < 0) {
                    cb.complete(MSException.Code.IllegalOp.getCode(), null, ctx);
                    return;
                }
                Iterator result = InMemoryMetastoreCursor.this.unsafeReadEntries(numEntries);
                cb.complete(MSException.Code.OK.getCode(), result, ctx);
            }
        });
    }

    private Iterator<MetastoreTableItem> unsafeReadEntries(int numEntries) {
        ArrayList<MetastoreTableItem> entries = new ArrayList<MetastoreTableItem>();
        for (int nCount = 0; this.iter.hasNext() && nCount < numEntries; ++nCount) {
            Map.Entry<String, Versioned<Value>> entry = this.iter.next();
            Versioned<Value> value = entry.getValue();
            Versioned<Value> vv = InMemoryMetastoreTable.cloneValue(value.getValue(), value.getVersion(), this.fields);
            String key = entry.getKey();
            entries.add(new MetastoreTableItem(key, vv));
        }
        return entries.iterator();
    }

    @Override
    public void close() throws IOException {
    }
}

