/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bk_v4_2_0.bookkeeper.meta;

import java.io.IOException;
import org.apache.bk_v4_2_0.bookkeeper.CreateMode;
import org.apache.bk_v4_2_0.bookkeeper.KeeperException;
import org.apache.bk_v4_2_0.bookkeeper.ZooDefs;
import org.apache.bk_v4_2_0.bookkeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LedgerLayout {
    static final Logger LOG = LoggerFactory.getLogger(LedgerLayout.class);
    public static final int LAYOUT_MIN_COMPAT_VERSION = 1;
    public static final int LAYOUT_FORMAT_VERSION = 2;
    static final String splitter = ":";
    static final String lSplitter = "\n";
    private String managerFactoryCls;
    private int managerVersion;
    private int layoutFormatVersion = 2;

    public static LedgerLayout readLayout(ZooKeeper zk, String ledgersRoot) throws IOException, KeeperException {
        String ledgersLayout = ledgersRoot + "/" + "LAYOUT";
        try {
            LedgerLayout layout;
            try {
                byte[] layoutData = zk.getData(ledgersLayout, false, null);
                layout = LedgerLayout.parseLayout(layoutData);
            }
            catch (KeeperException.NoNodeException nne) {
                return null;
            }
            return layout;
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
    }

    public LedgerLayout(String managerFactoryCls, int managerVersion) {
        this(managerFactoryCls, managerVersion, 2);
    }

    LedgerLayout(String managerFactoryCls, int managerVersion, int layoutVersion) {
        this.managerFactoryCls = managerFactoryCls;
        this.managerVersion = managerVersion;
        this.layoutFormatVersion = layoutVersion;
    }

    @Deprecated
    public String getManagerType() {
        return this.managerFactoryCls;
    }

    public String getManagerFactoryClass() {
        return this.managerFactoryCls;
    }

    public int getManagerVersion() {
        return this.managerVersion;
    }

    public int getLayoutFormatVersion() {
        return this.layoutFormatVersion;
    }

    public void store(ZooKeeper zk, String ledgersRoot) throws IOException, KeeperException, InterruptedException {
        String ledgersLayout = ledgersRoot + "/" + "LAYOUT";
        zk.create(ledgersLayout, this.serialize(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
    }

    public void delete(ZooKeeper zk, String ledgersRoot) throws KeeperException, InterruptedException {
        String ledgersLayout = ledgersRoot + "/" + "LAYOUT";
        zk.delete(ledgersLayout, -1);
    }

    private byte[] serialize() throws IOException {
        String s = this.layoutFormatVersion + lSplitter + this.managerFactoryCls + splitter + this.managerVersion;
        LOG.debug("Serialized layout info: {}", (Object)s);
        return s.getBytes("UTF-8");
    }

    private static LedgerLayout parseLayout(byte[] bytes) throws IOException {
        String layout = new String(bytes, "UTF-8");
        LOG.debug("Parsing Layout: {}", (Object)layout);
        String[] lines = layout.split(lSplitter);
        try {
            int layoutFormatVersion = new Integer(lines[0]);
            if (2 < layoutFormatVersion || 1 > layoutFormatVersion) {
                throw new IOException("Metadata version not compatible. Expected 2, but got " + layoutFormatVersion);
            }
            if (lines.length < 2) {
                throw new IOException("Ledger manager and its version absent from layout: " + layout);
            }
            String[] parts = lines[1].split(splitter);
            if (parts.length != 2) {
                throw new IOException("Invalid Ledger Manager defined in layout : " + layout);
            }
            String managerFactoryCls = parts[0];
            int managerVersion = new Integer(parts[1]);
            return new LedgerLayout(managerFactoryCls, managerVersion, layoutFormatVersion);
        }
        catch (NumberFormatException e) {
            throw new IOException("Could not parse layout '" + layout + "'", e);
        }
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (!(obj instanceof LedgerLayout)) {
            return false;
        }
        LedgerLayout other = (LedgerLayout)obj;
        return this.managerFactoryCls.equals(other.managerFactoryCls) && this.managerVersion == other.managerVersion;
    }

    public int hashCode() {
        return (this.managerFactoryCls + this.managerVersion).hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LV").append(this.layoutFormatVersion).append(splitter).append(",Type:").append(this.managerFactoryCls).append(splitter).append(this.managerVersion);
        return sb.toString();
    }
}

