/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bk_v4_2_0.bookkeeper.client;

import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.apache.bk_v4_2_0.bookkeeper.AsyncCallback;
import org.apache.bk_v4_2_0.bookkeeper.ClientCnxn;
import org.apache.bk_v4_2_0.bookkeeper.Login;
import org.apache.bk_v4_2_0.bookkeeper.data.Stat;
import org.apache.bk_v4_2_0.bookkeeper.proto.GetSASLRequest;
import org.apache.bk_v4_2_0.bookkeeper.proto.ReplyHeader;
import org.apache.bk_v4_2_0.bookkeeper.proto.RequestHeader;
import org.apache.bk_v4_2_0.bookkeeper.proto.SetSASLResponse;
import org.apache.bk_v4_2_0.bookkeeper.server.auth.KerberosName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperSaslClient {
    public static final String LOGIN_CONTEXT_NAME_KEY = "zookeeper.sasl.clientconfig";
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperSaslClient.class);
    private static Login login = null;
    private SaslClient saslClient;
    private byte[] saslToken = new byte[0];
    private SaslState saslState = SaslState.INITIAL;
    private String loginContext;

    public SaslState getSaslState() {
        return this.saslState;
    }

    public String getLoginContext() {
        return this.loginContext;
    }

    public ZooKeeperSaslClient(String serverPrincipal) throws LoginException {
        String clientSection = System.getProperty(LOGIN_CONTEXT_NAME_KEY, "Client");
        AppConfigurationEntry[] entries = null;
        SecurityException securityException = null;
        try {
            entries = Configuration.getConfiguration().getAppConfigurationEntry(clientSection);
        }
        catch (SecurityException e) {
            securityException = e;
        }
        if (entries != null) {
            LOG.info("Found Login Context section '" + clientSection + "': will use it to attempt to SASL-authenticate.");
            this.saslClient = this.createSaslClient(serverPrincipal, clientSection);
        } else {
            this.saslState = SaslState.FAILED;
            String explicitClientSection = System.getProperty(LOGIN_CONTEXT_NAME_KEY);
            if (explicitClientSection != null) {
                if (securityException != null) {
                    throw new LoginException("Zookeeper client cannot authenticate using the " + explicitClientSection + " section of the supplied JAAS configuration: '" + System.getProperty("java.security.auth.login.config") + "' because of a " + "SecurityException: " + securityException);
                }
                throw new LoginException("Client cannot SASL-authenticate because the specified JAAS configuration section '" + explicitClientSection + "' could not be found.");
            }
            if (securityException != null) {
                LOG.warn("SecurityException: " + securityException + " occurred when trying to find JAAS configuration.");
            }
            LOG.info("Client will not SASL-authenticate because the default JAAS configuration section 'Client' could not be found. If you are not using SASL, you may ignore this. On the other hand, if you expected SASL to work, please fix your JAAS configuration.");
            if (System.getProperty("java.security.auth.login.config") != null) {
                if (securityException != null) {
                    throw new LoginException("Zookeeper client cannot authenticate using the '" + System.getProperty(LOGIN_CONTEXT_NAME_KEY, "Client") + "' section of the supplied JAAS configuration: '" + System.getProperty("java.security.auth.login.config") + "' because of a " + "SecurityException: " + securityException);
                }
                throw new LoginException("No JAAS configuration section named '" + System.getProperty(LOGIN_CONTEXT_NAME_KEY, "Client") + "' was found in specified JAAS configuration file: '" + System.getProperty("java.security.auth.login.config") + "'.");
            }
        }
    }

    public boolean isComplete() {
        return this.saslState == SaslState.COMPLETE;
    }

    public boolean isFailed() {
        return this.saslState == SaslState.FAILED;
    }

    private synchronized SaslClient createSaslClient(String servicePrincipal, String loginContext) throws LoginException {
        try {
            Subject subject;
            if (login == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("JAAS loginContext is: " + loginContext);
                }
                this.loginContext = loginContext;
                login = new Login(loginContext, new ClientCallbackHandler(null));
                login.startThreadIfNeeded();
            }
            if ((subject = login.getSubject()).getPrincipals().isEmpty()) {
                LOG.info("Client will use DIGEST-MD5 as SASL mechanism.");
                String[] mechs = new String[]{"DIGEST-MD5"};
                String username = (String)subject.getPublicCredentials().toArray()[0];
                String password = (String)subject.getPrivateCredentials().toArray()[0];
                SaslClient saslClient = Sasl.createSaslClient(mechs, username, "zookeeper", "zk-sasl-md5", null, new ClientCallbackHandler(password));
                return saslClient;
            }
            Object[] principals = subject.getPrincipals().toArray();
            Principal clientPrincipal = (Principal)principals[0];
            KerberosName clientKerberosName = new KerberosName(clientPrincipal.getName());
            String serverRealm = System.getProperty("zookeeper.server.realm", clientKerberosName.getRealm());
            KerberosName serviceKerberosName = new KerberosName(servicePrincipal + "@" + serverRealm);
            final String serviceName = serviceKerberosName.getServiceName();
            final String serviceHostname = serviceKerberosName.getHostName();
            final String clientPrincipalName = clientKerberosName.toString();
            try {
                SaslClient saslClient = Subject.doAs(subject, new PrivilegedExceptionAction<SaslClient>(){

                    @Override
                    public SaslClient run() throws SaslException {
                        LOG.info("Client will use GSSAPI as SASL mechanism.");
                        String[] mechs = new String[]{"GSSAPI"};
                        LOG.debug("creating sasl client: client=" + clientPrincipalName + ";service=" + serviceName + ";serviceHostname=" + serviceHostname);
                        SaslClient saslClient = Sasl.createSaslClient(mechs, clientPrincipalName, serviceName, serviceHostname, null, new ClientCallbackHandler(null));
                        return saslClient;
                    }
                });
                return saslClient;
            }
            catch (Exception e) {
                LOG.error("Error creating SASL client:" + e);
                e.printStackTrace();
                return null;
            }
        }
        catch (LoginException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error("Exception while trying to create SASL client: " + e);
            return null;
        }
    }

    private void prepareSaslResponseToServer(byte[] serverToken, ClientCnxn cnxn) {
        this.saslToken = serverToken;
        if (this.saslClient == null) {
            LOG.error("saslClient is unexpectedly null. Cannot respond to server's SASL message; ignoring.");
            return;
        }
        LOG.debug("saslToken (server) length: " + this.saslToken.length);
        if (!this.saslClient.isComplete()) {
            try {
                this.saslToken = this.createSaslToken(this.saslToken);
                if (this.saslToken != null) {
                    LOG.debug("saslToken (client) length: " + this.saslToken.length);
                    this.queueSaslPacket(this.saslToken, cnxn);
                }
            }
            catch (SaslException e) {
                LOG.error("SASL authentication failed using login context '" + this.getLoginContext() + "'.");
                this.saslState = SaslState.FAILED;
            }
        }
    }

    private byte[] createSaslToken() throws SaslException {
        this.saslState = SaslState.INTERMEDIATE;
        return this.createSaslToken(this.saslToken);
    }

    private byte[] createSaslToken(final byte[] saslToken) throws SaslException {
        if (saslToken == null) {
            throw new SaslException("Error in authenticating with a Zookeeper Quorum member: the quorum member's saslToken is null.");
        }
        Subject subject = login.getSubject();
        if (subject != null) {
            Login login = ZooKeeperSaslClient.login;
            synchronized (login) {
                try {
                    byte[] retval = Subject.doAs(subject, new PrivilegedExceptionAction<byte[]>(){

                        @Override
                        public byte[] run() throws SaslException {
                            LOG.debug("saslClient.evaluateChallenge(len=" + saslToken.length + ")");
                            return ZooKeeperSaslClient.this.saslClient.evaluateChallenge(saslToken);
                        }
                    });
                    return retval;
                }
                catch (PrivilegedActionException e) {
                    String error = "An error: (" + e + ") occurred when evaluating Zookeeper Quorum Member's " + " received SASL token.";
                    String UNKNOWN_SERVER_ERROR_TEXT = "(Mechanism level: Server not found in Kerberos database (7) - UNKNOWN_SERVER)";
                    if (e.toString().indexOf("(Mechanism level: Server not found in Kerberos database (7) - UNKNOWN_SERVER)") > -1) {
                        error = error + " This may be caused by Java's being unable to resolve the Zookeeper Quorum Member's hostname correctly. You may want to try to adding '-Dsun.net.spi.nameservice.provider.1=dns,sun' to your client's JVMFLAGS environment.";
                    }
                    error = error + " Zookeeper Client will go to AUTH_FAILED state.";
                    LOG.error(error);
                    throw new SaslException(error);
                }
            }
        }
        throw new SaslException("Cannot make SASL token without subject defined. For diagnosis, please look for WARNs and ERRORs in your log related to the Login class.");
    }

    private void queueSaslPacket(byte[] saslToken, ClientCnxn cnxn) {
        LOG.debug("ClientCnxn:sendSaslPacket:length=" + saslToken.length);
        RequestHeader h = new RequestHeader();
        h.setType(102);
        GetSASLRequest request = new GetSASLRequest();
        request.setToken(saslToken);
        SetSASLResponse response = new SetSASLResponse();
        ServerSaslResponseCallback cb = new ServerSaslResponseCallback();
        ReplyHeader r = new ReplyHeader();
        cnxn.queuePacket(h, r, request, response, cb);
    }

    private void queueSaslPacket(ClientCnxn cnxn) throws SaslException {
        this.queueSaslPacket(this.createSaslToken(), cnxn);
    }

    public boolean readyToSendSaslAuthEvent() {
        if (this.saslClient != null) {
            if (this.saslClient.isComplete() && this.saslState == SaslState.INTERMEDIATE) {
                this.saslState = SaslState.COMPLETE;
                return true;
            }
        } else {
            LOG.warn("saslClient is null: client could not authenticate properly.");
        }
        return false;
    }

    public void initialize(ClientCnxn cnxn) throws SaslException {
        if (this.saslClient == null) {
            throw new SaslException("saslClient failed to initialize properly: it's null.");
        }
        if (this.saslState == SaslState.INITIAL) {
            if (this.saslClient.hasInitialResponse()) {
                this.queueSaslPacket(cnxn);
            } else {
                byte[] emptyToken = new byte[]{};
                this.queueSaslPacket(emptyToken, cnxn);
            }
            this.saslState = SaslState.INTERMEDIATE;
        }
    }

    public static class ClientCallbackHandler
    implements CallbackHandler {
        private String password = null;

        public ClientCallbackHandler(String password) {
            this.password = password;
        }

        public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    NameCallback nc = (NameCallback)callback;
                    nc.setName(nc.getDefaultName());
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    PasswordCallback pc = (PasswordCallback)callback;
                    if (this.password != null) {
                        pc.setPassword(this.password.toCharArray());
                        continue;
                    }
                    LOG.warn("Could not login: the client is being asked for a password, but the Zookeeper client code does not currently support obtaining a password from the user. Make sure that the client is configured to use a ticket cache (using the JAAS configuration setting 'useTicketCache=true)' and restart the client. If you still get this message after that, the TGT in the ticket cache has expired and must be manually refreshed. To do so, first determine if you are using a password or a keytab. If the former, run kinit in a Unix shell in the environment of the user who is running this Zookeeper client using the command 'kinit <princ>' (where <princ> is the name of the client's Kerberos principal). If the latter, do 'kinit -k -t <keytab> <princ>' (where <princ> is the name of the Kerberos principal, and <keytab> is the location of the keytab file). After manually refreshing your cache, restart this client. If you continue to see this message after manually refreshing your cache, ensure that your KDC host's clock is in sync with this host's clock.");
                    continue;
                }
                if (callback instanceof RealmCallback) {
                    RealmCallback rc = (RealmCallback)callback;
                    rc.setText(rc.getDefaultText());
                    continue;
                }
                if (callback instanceof AuthorizeCallback) {
                    String authzid;
                    AuthorizeCallback ac = (AuthorizeCallback)callback;
                    String authid = ac.getAuthenticationID();
                    if (authid.equals(authzid = ac.getAuthorizationID())) {
                        ac.setAuthorized(true);
                    } else {
                        ac.setAuthorized(false);
                    }
                    if (!ac.isAuthorized()) continue;
                    ac.setAuthorizedID(authzid);
                    continue;
                }
                throw new UnsupportedCallbackException(callback, "Unrecognized SASL ClientCallback");
            }
        }
    }

    public static class ServerSaslResponseCallback
    implements AsyncCallback.DataCallback {
        public void processResult(int rc, String path, Object ctx, byte[] data, Stat stat) {
            ZooKeeperSaslClient client = ((ClientCnxn)ctx).zooKeeperSaslClient;
            if (client == null) {
                LOG.warn("sasl client was unexpectedly null: cannot respond to Zookeeper server.");
                return;
            }
            byte[] usedata = data;
            if (data != null) {
                LOG.debug("ServerSaslResponseCallback(): saslToken server response: (length=" + usedata.length + ")");
            } else {
                usedata = new byte[]{};
                LOG.debug("ServerSaslResponseCallback(): using empty data[] as server response (length=" + usedata.length + ")");
            }
            client.prepareSaslResponseToServer(usedata, (ClientCnxn)ctx);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SaslState {
        INITIAL,
        INTERMEDIATE,
        COMPLETE,
        FAILED;

    }
}

