/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bk_v4_2_0.bookkeeper.client;

import com.google.bk_v4_2_0.common.util.concurrent.RateLimiter;
import java.net.InetSocketAddress;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.bk_v4_2_0.bookkeeper.client.AsyncCallback;
import org.apache.bk_v4_2_0.bookkeeper.client.BKException;
import org.apache.bk_v4_2_0.bookkeeper.client.BookKeeper;
import org.apache.bk_v4_2_0.bookkeeper.client.DigestManager;
import org.apache.bk_v4_2_0.bookkeeper.client.DistributionSchedule;
import org.apache.bk_v4_2_0.bookkeeper.client.LedgerEntry;
import org.apache.bk_v4_2_0.bookkeeper.client.LedgerMetadata;
import org.apache.bk_v4_2_0.bookkeeper.client.LedgerRecoveryOp;
import org.apache.bk_v4_2_0.bookkeeper.client.MacDigestManager;
import org.apache.bk_v4_2_0.bookkeeper.client.PendingAddOp;
import org.apache.bk_v4_2_0.bookkeeper.client.PendingReadOp;
import org.apache.bk_v4_2_0.bookkeeper.client.ReadLastConfirmedOp;
import org.apache.bk_v4_2_0.bookkeeper.client.RoundRobinDistributionSchedule;
import org.apache.bk_v4_2_0.bookkeeper.client.SyncCounter;
import org.apache.bk_v4_2_0.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bk_v4_2_0.bookkeeper.proto.DataFormats;
import org.apache.bk_v4_2_0.bookkeeper.util.OrderedSafeExecutor;
import org.apache.bk_v4_2_0.bookkeeper.util.SafeRunnable;
import org.jboss.bk_v4_2_0.netty.buffer.ChannelBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LedgerHandle {
    static final Logger LOG = LoggerFactory.getLogger(LedgerHandle.class);
    final byte[] ledgerKey;
    LedgerMetadata metadata;
    final BookKeeper bk;
    final long ledgerId;
    long lastAddPushed;
    long lastAddConfirmed;
    long length;
    final DigestManager macManager;
    final DistributionSchedule distributionSchedule;
    final RateLimiter throttler;
    public static final long INVALID_ENTRY_ID = -1L;
    final AtomicInteger blockAddCompletions = new AtomicInteger(0);
    final Queue<PendingAddOp> pendingAddOps = new ConcurrentLinkedQueue<PendingAddOp>();

    LedgerHandle(BookKeeper bk, long ledgerId, LedgerMetadata metadata, BookKeeper.DigestType digestType, byte[] password) throws GeneralSecurityException, NumberFormatException {
        this.bk = bk;
        this.metadata = metadata;
        if (metadata.isClosed()) {
            this.lastAddConfirmed = this.lastAddPushed = metadata.getLastEntryId();
            this.length = metadata.getLength();
        } else {
            this.lastAddPushed = -1L;
            this.lastAddConfirmed = -1L;
            this.length = 0L;
        }
        this.ledgerId = ledgerId;
        this.throttler = RateLimiter.create(bk.getConf().getThrottleValue());
        this.macManager = DigestManager.instantiate(ledgerId, password, digestType);
        this.ledgerKey = MacDigestManager.genDigest("ledger", password);
        this.distributionSchedule = new RoundRobinDistributionSchedule(metadata.getWriteQuorumSize(), metadata.getAckQuorumSize(), metadata.getEnsembleSize());
    }

    public long getId() {
        return this.ledgerId;
    }

    public long getLastAddConfirmed() {
        return this.lastAddConfirmed;
    }

    public synchronized long getLastAddPushed() {
        return this.lastAddPushed;
    }

    public byte[] getLedgerKey() {
        return Arrays.copyOf(this.ledgerKey, this.ledgerKey.length);
    }

    LedgerMetadata getLedgerMetadata() {
        return this.metadata;
    }

    DigestManager getDigestManager() {
        return this.macManager;
    }

    long addToLength(long delta) {
        this.length += delta;
        return this.length;
    }

    public synchronized long getLength() {
        return this.length;
    }

    DistributionSchedule getDistributionSchedule() {
        return this.distributionSchedule;
    }

    void writeLedgerConfig(BookkeeperInternalCallbacks.GenericCallback<Void> writeCb) {
        LOG.debug("Writing metadata to ledger manager: {}, {}", (Object)this.ledgerId, (Object)this.metadata.getVersion());
        this.bk.getLedgerManager().writeLedgerMetadata(this.ledgerId, this.metadata, writeCb);
    }

    public void close() throws InterruptedException, BKException {
        SyncCounter counter = new SyncCounter();
        counter.inc();
        this.asyncClose(new SyncCloseCallback(), counter);
        counter.block(0);
        if (counter.getrc() != 0) {
            throw BKException.create(counter.getrc());
        }
    }

    public void asyncClose(AsyncCallback.CloseCallback cb, Object ctx) {
        this.asyncCloseInternal(cb, ctx, -11);
    }

    void asyncCloseInternal(final AsyncCallback.CloseCallback cb, final Object ctx, final int rc) {
        this.bk.mainWorkerPool.submitOrdered(this.ledgerId, new SafeRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void safeRun() {
                long prevLength;
                long prevLastEntryId;
                DataFormats.LedgerMetadataFormat.State prevState;
                LedgerHandle ledgerHandle = LedgerHandle.this;
                synchronized (ledgerHandle) {
                    prevState = LedgerHandle.this.metadata.getState();
                    prevLastEntryId = LedgerHandle.this.metadata.getLastEntryId();
                    prevLength = LedgerHandle.this.metadata.getLength();
                    LedgerHandle.this.metadata.setLength(LedgerHandle.this.length);
                    LedgerHandle.this.metadata.close(LedgerHandle.this.lastAddConfirmed);
                    LedgerHandle.this.errorOutPendingAdds(rc);
                    LedgerHandle.this.lastAddPushed = LedgerHandle.this.lastAddConfirmed;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Closing ledger: " + LedgerHandle.this.ledgerId + " at entryId: " + LedgerHandle.this.metadata.getLastEntryId() + " with this many bytes: " + LedgerHandle.this.metadata.getLength());
                }
                final class CloseCb
                extends OrderedSafeExecutor.OrderedSafeGenericCallback<Void> {
                    final /* synthetic */ DataFormats.LedgerMetadataFormat.State val$prevState;
                    final /* synthetic */ long val$prevLastEntryId;
                    final /* synthetic */ long val$prevLength;

                    CloseCb() {
                        this.val$prevState = state;
                        this.val$prevLastEntryId = l;
                        this.val$prevLength = l2;
                        super(LedgerHandle.this.bk.mainWorkerPool, LedgerHandle.this.ledgerId);
                    }

                    @Override
                    public void safeOperationComplete(final int rc, Void result) {
                        if (rc == -17) {
                            LedgerHandle.this.rereadMetadata((BookkeeperInternalCallbacks.GenericCallback<LedgerMetadata>)new OrderedSafeExecutor.OrderedSafeGenericCallback<LedgerMetadata>(LedgerHandle.this.bk.mainWorkerPool, (Object)LedgerHandle.this.ledgerId){

                                @Override
                                public void safeOperationComplete(int newrc, LedgerMetadata newMeta) {
                                    if (newrc != 0) {
                                        LOG.error("Error reading new metadata from ledger " + LedgerHandle.this.ledgerId + " when closing, code=" + newrc);
                                        cb.closeComplete(rc, LedgerHandle.this, ctx);
                                    } else {
                                        LedgerHandle.this.metadata.setState(val$prevState);
                                        if (val$prevState.equals(DataFormats.LedgerMetadataFormat.State.CLOSED)) {
                                            LedgerHandle.this.metadata.close(val$prevLastEntryId);
                                        }
                                        LedgerHandle.this.metadata.setLength(val$prevLength);
                                        if (LedgerHandle.this.metadata.resolveConflict(newMeta)) {
                                            LedgerHandle.this.metadata.setLength(LedgerHandle.this.length);
                                            LedgerHandle.this.metadata.close(LedgerHandle.this.lastAddConfirmed);
                                            LedgerHandle.this.writeLedgerConfig(new CloseCb(this, val$prevState, val$prevLastEntryId, val$prevLength));
                                            return;
                                        }
                                        LedgerHandle.this.metadata.setLength(LedgerHandle.this.length);
                                        LedgerHandle.this.metadata.close(LedgerHandle.this.lastAddConfirmed);
                                        LOG.warn("Conditional update ledger metadata for ledger " + LedgerHandle.this.ledgerId + " failed.");
                                        cb.closeComplete(rc, LedgerHandle.this, ctx);
                                    }
                                }
                            });
                        } else if (rc != 0) {
                            LOG.error("Error update ledger metadata for ledger " + LedgerHandle.this.ledgerId + " : " + rc);
                            cb.closeComplete(rc, LedgerHandle.this, ctx);
                        } else {
                            cb.closeComplete(0, LedgerHandle.this, ctx);
                        }
                    }
                }
                LedgerHandle.this.writeLedgerConfig(new CloseCb());
            }
        });
    }

    public Enumeration<LedgerEntry> readEntries(long firstEntry, long lastEntry) throws InterruptedException, BKException {
        SyncCounter counter = new SyncCounter();
        counter.inc();
        this.asyncReadEntries(firstEntry, lastEntry, new SyncReadCallback(), counter);
        counter.block(0);
        if (counter.getrc() != 0) {
            throw BKException.create(counter.getrc());
        }
        return counter.getSequence();
    }

    public void asyncReadEntries(long firstEntry, long lastEntry, AsyncCallback.ReadCallback cb, Object ctx) {
        if (firstEntry < 0L || lastEntry > this.lastAddConfirmed || firstEntry > lastEntry) {
            cb.readComplete(-1, this, null, ctx);
            return;
        }
        try {
            new PendingReadOp(this, this.bk.scheduler, firstEntry, lastEntry, cb, ctx).initiate();
        }
        catch (InterruptedException e) {
            cb.readComplete(-15, this, null, ctx);
        }
    }

    public long addEntry(byte[] data) throws InterruptedException, BKException {
        return this.addEntry(data, 0, data.length);
    }

    public long addEntry(byte[] data, int offset, int length) throws InterruptedException, BKException {
        LOG.debug("Adding entry {}", (Object)data);
        SyncCounter counter = new SyncCounter();
        counter.inc();
        SyncAddCallback callback = new SyncAddCallback();
        this.asyncAddEntry(data, offset, length, callback, counter);
        counter.block(0);
        if (counter.getrc() != 0) {
            throw BKException.create(counter.getrc());
        }
        return callback.entryId;
    }

    public void asyncAddEntry(byte[] data, AsyncCallback.AddCallback cb, Object ctx) {
        this.asyncAddEntry(data, 0, data.length, cb, ctx);
    }

    public void asyncAddEntry(byte[] data, int offset, int length, AsyncCallback.AddCallback cb, Object ctx) {
        PendingAddOp op = new PendingAddOp(this, cb, ctx);
        this.doAsyncAddEntry(op, data, offset, length, cb, ctx);
    }

    void asyncRecoveryAddEntry(byte[] data, int offset, int length, AsyncCallback.AddCallback cb, Object ctx) {
        PendingAddOp op = new PendingAddOp(this, cb, ctx).enableRecoveryAdd();
        this.doAsyncAddEntry(op, data, offset, length, cb, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAsyncAddEntry(final PendingAddOp op, final byte[] data, final int offset, final int length, AsyncCallback.AddCallback cb, Object ctx) {
        long currentLength;
        long entryId;
        if (offset < 0 || length < 0 || offset + length > data.length) {
            throw new ArrayIndexOutOfBoundsException("Invalid values for offset(" + offset + ") or length(" + length + ")");
        }
        this.throttler.acquire();
        LedgerHandle ledgerHandle = this;
        synchronized (ledgerHandle) {
            if (this.metadata.isClosed()) {
                LOG.warn("Attempt to add to closed ledger: " + this.ledgerId);
                cb.addComplete(-11, this, -1L, ctx);
                return;
            }
            entryId = ++this.lastAddPushed;
            currentLength = this.addToLength(length);
            op.setEntryId(entryId);
            this.pendingAddOps.add(op);
        }
        try {
            this.bk.mainWorkerPool.submit(new SafeRunnable(){

                @Override
                public void safeRun() {
                    ChannelBuffer toSend = LedgerHandle.this.macManager.computeDigestAndPackageForSending(entryId, LedgerHandle.this.lastAddConfirmed, currentLength, data, offset, length);
                    op.initiate(toSend);
                }
            });
        }
        catch (RuntimeException e) {
            cb.addComplete(-15, this, -1L, ctx);
        }
    }

    public void asyncReadLastConfirmed(final AsyncCallback.ReadLastConfirmedCallback cb, final Object ctx) {
        ReadLastConfirmedOp.LastConfirmedDataCallback innercb = new ReadLastConfirmedOp.LastConfirmedDataCallback(){

            @Override
            public void readLastConfirmedDataComplete(int rc, DigestManager.RecoveryData data) {
                if (rc == 0) {
                    LedgerHandle.this.lastAddConfirmed = Math.max(LedgerHandle.this.lastAddConfirmed, data.lastAddConfirmed);
                    LedgerHandle.this.lastAddPushed = Math.max(LedgerHandle.this.lastAddPushed, data.lastAddConfirmed);
                    LedgerHandle.this.length = Math.max(LedgerHandle.this.length, data.length);
                    cb.readLastConfirmedComplete(rc, data.lastAddConfirmed, ctx);
                } else {
                    cb.readLastConfirmedComplete(rc, -1L, ctx);
                }
            }
        };
        new ReadLastConfirmedOp(this, innercb).initiate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long readLastConfirmed() throws InterruptedException, BKException {
        LastConfirmedCtx ctx = new LastConfirmedCtx();
        this.asyncReadLastConfirmed(new SyncReadLastConfirmedCallback(), ctx);
        LastConfirmedCtx lastConfirmedCtx = ctx;
        synchronized (lastConfirmedCtx) {
            while (!ctx.ready()) {
                ctx.wait();
            }
        }
        if (ctx.getRC() != 0) {
            throw BKException.create(ctx.getRC());
        }
        return ctx.getlastConfirmed();
    }

    void handleUnrecoverableErrorDuringAdd(int rc) {
        if (this.metadata.isInRecovery()) {
            this.errorOutPendingAdds(rc);
            return;
        }
        this.asyncCloseInternal(NoopCloseCallback.instance, null, rc);
    }

    void errorOutPendingAdds(int rc) {
        PendingAddOp pendingAddOp;
        while ((pendingAddOp = this.pendingAddOps.poll()) != null) {
            pendingAddOp.submitCallback(rc);
        }
    }

    void sendAddSuccessCallbacks() {
        PendingAddOp pendingAddOp;
        while ((pendingAddOp = this.pendingAddOps.peek()) != null && this.blockAddCompletions.get() == 0) {
            if (!pendingAddOp.completed) {
                return;
            }
            this.pendingAddOps.remove();
            this.lastAddConfirmed = pendingAddOp.entryId;
            pendingAddOp.submitCallback(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArrayList<InetSocketAddress> replaceBookieInMetadata(InetSocketAddress addr, int bookieIndex) throws BKException.BKNotEnoughBookiesException {
        LOG.info("Handling failure of bookie: {} index: {}", (Object)addr, (Object)bookieIndex);
        ArrayList<InetSocketAddress> newEnsemble = new ArrayList<InetSocketAddress>();
        long newEnsembleStartEntry = this.lastAddConfirmed + 1L;
        LedgerMetadata ledgerMetadata = this.metadata;
        synchronized (ledgerMetadata) {
            InetSocketAddress newBookie = this.bk.bookieWatcher.getAdditionalBookie(this.metadata.currentEnsemble);
            newEnsemble.addAll(this.metadata.currentEnsemble);
            newEnsemble.set(bookieIndex, newBookie);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Changing ensemble from: " + this.metadata.currentEnsemble + " to: " + newEnsemble + " for ledger: " + this.ledgerId + " starting at entry: " + (this.lastAddConfirmed + 1L));
            }
            this.metadata.addEnsemble(newEnsembleStartEntry, newEnsemble);
        }
        return newEnsemble;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleBookieFailure(InetSocketAddress addr, int bookieIndex) {
        this.blockAddCompletions.incrementAndGet();
        LedgerMetadata ledgerMetadata = this.metadata;
        synchronized (ledgerMetadata) {
            if (!this.metadata.currentEnsemble.get(bookieIndex).equals(addr)) {
                LOG.warn("Write did not succeed to {}, bookieIndex {}, but we have already fixed it.", (Object)addr, (Object)bookieIndex);
                this.blockAddCompletions.decrementAndGet();
                return;
            }
            try {
                ArrayList<InetSocketAddress> newEnsemble = this.replaceBookieInMetadata(addr, bookieIndex);
                EnsembleInfo ensembleInfo = new EnsembleInfo(newEnsemble, bookieIndex, addr);
                this.writeLedgerConfig(new ChangeEnsembleCb(ensembleInfo));
            }
            catch (BKException.BKNotEnoughBookiesException e) {
                LOG.error("Could not get additional bookie to remake ensemble, closing ledger: " + this.ledgerId);
                this.handleUnrecoverableErrorDuringAdd(e.getCode());
                return;
            }
        }
    }

    void unsetSuccessAndSendWriteRequest(int bookieIndex) {
        for (PendingAddOp pendingAddOp : this.pendingAddOps) {
            pendingAddOp.unsetSuccessAndSendWriteRequest(bookieIndex);
        }
    }

    void rereadMetadata(BookkeeperInternalCallbacks.GenericCallback<LedgerMetadata> cb) {
        this.bk.getLedgerManager().readLedgerMetadata(this.ledgerId, cb);
    }

    synchronized void recover(final BookkeeperInternalCallbacks.GenericCallback<Void> cb) {
        if (this.metadata.isClosed()) {
            this.lastAddConfirmed = this.lastAddPushed = this.metadata.getLastEntryId();
            this.length = this.metadata.getLength();
            cb.operationComplete(0, null);
            return;
        }
        if (this.metadata.isInRecovery()) {
            new LedgerRecoveryOp(this, cb).initiate();
            return;
        }
        this.metadata.markLedgerInRecovery();
        this.writeLedgerConfig((BookkeeperInternalCallbacks.GenericCallback<Void>)new OrderedSafeExecutor.OrderedSafeGenericCallback<Void>(this.bk.mainWorkerPool, (Object)this.ledgerId){

            @Override
            public void safeOperationComplete(int rc, Void result) {
                if (rc == -17) {
                    LedgerHandle.this.rereadMetadata((BookkeeperInternalCallbacks.GenericCallback<LedgerMetadata>)new OrderedSafeExecutor.OrderedSafeGenericCallback<LedgerMetadata>(LedgerHandle.this.bk.mainWorkerPool, (Object)LedgerHandle.this.ledgerId){

                        @Override
                        public void safeOperationComplete(int rc, LedgerMetadata newMeta) {
                            if (rc != 0) {
                                cb.operationComplete(rc, null);
                            } else {
                                LedgerHandle.this.metadata = newMeta;
                                LedgerHandle.this.recover(cb);
                            }
                        }
                    });
                } else if (rc == 0) {
                    new LedgerRecoveryOp(LedgerHandle.this, cb).initiate();
                } else {
                    LOG.error("Error writing ledger config " + rc + " of ledger " + LedgerHandle.this.ledgerId);
                    cb.operationComplete(rc, null);
                }
            }
        });
    }

    private static class SyncCloseCallback
    implements AsyncCallback.CloseCallback {
        private SyncCloseCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void closeComplete(int rc, LedgerHandle lh, Object ctx) {
            SyncCounter counter = (SyncCounter)ctx;
            counter.setrc(rc);
            SyncCounter syncCounter = counter;
            synchronized (syncCounter) {
                counter.dec();
                counter.notify();
            }
        }
    }

    private static class SyncReadLastConfirmedCallback
    implements AsyncCallback.ReadLastConfirmedCallback {
        private SyncReadLastConfirmedCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void readLastConfirmedComplete(int rc, long lastConfirmed, Object ctx) {
            LastConfirmedCtx lcCtx;
            LastConfirmedCtx lastConfirmedCtx = lcCtx = (LastConfirmedCtx)ctx;
            synchronized (lastConfirmedCtx) {
                lcCtx.setRC(rc);
                lcCtx.setLastConfirmed(lastConfirmed);
                lcCtx.notify();
            }
        }
    }

    private static class SyncAddCallback
    implements AsyncCallback.AddCallback {
        long entryId = -1L;

        private SyncAddCallback() {
        }

        @Override
        public void addComplete(int rc, LedgerHandle lh, long entry, Object ctx) {
            SyncCounter counter = (SyncCounter)ctx;
            this.entryId = entry;
            counter.setrc(rc);
            counter.dec();
        }
    }

    private static class SyncReadCallback
    implements AsyncCallback.ReadCallback {
        private SyncReadCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void readComplete(int rc, LedgerHandle lh, Enumeration<LedgerEntry> seq, Object ctx) {
            SyncCounter counter;
            SyncCounter syncCounter = counter = (SyncCounter)ctx;
            synchronized (syncCounter) {
                counter.setSequence(seq);
                counter.setrc(rc);
                counter.dec();
                counter.notify();
            }
        }
    }

    static class NoopCloseCallback
    implements AsyncCallback.CloseCallback {
        static NoopCloseCallback instance = new NoopCloseCallback();

        NoopCloseCallback() {
        }

        @Override
        public void closeComplete(int rc, LedgerHandle lh, Object ctx) {
            if (rc != 0) {
                LOG.warn("Close failed: " + BKException.getMessage(rc));
            }
        }
    }

    private final class ReReadLedgerMetadataCb
    extends OrderedSafeExecutor.OrderedSafeGenericCallback<LedgerMetadata> {
        private final int rc;
        private final EnsembleInfo ensembleInfo;

        ReReadLedgerMetadataCb(int rc, EnsembleInfo ensembleInfo) {
            super(LedgerHandle.this.bk.mainWorkerPool, LedgerHandle.this.ledgerId);
            this.rc = rc;
            this.ensembleInfo = ensembleInfo;
        }

        @Override
        public void safeOperationComplete(int newrc, LedgerMetadata newMeta) {
            if (newrc != 0) {
                LOG.error("Error reading new metadata from ledger after changing ensemble, code=" + newrc);
                LedgerHandle.this.handleUnrecoverableErrorDuringAdd(this.rc);
            } else if (!this.resolveConflict(newMeta)) {
                LOG.error("Could not resolve ledger metadata conflict while changing ensemble to: " + this.ensembleInfo.newEnsemble + ", old meta data is \n" + new String(LedgerHandle.this.metadata.serialize()) + "\n, new meta data is \n" + new String(newMeta.serialize()) + "\n ,closing ledger");
                LedgerHandle.this.handleUnrecoverableErrorDuringAdd(this.rc);
            }
        }

        private boolean resolveConflict(LedgerMetadata newMeta) {
            if (LedgerHandle.this.metadata.getState() != newMeta.getState()) {
                return false;
            }
            LedgerHandle.this.metadata.setVersion(newMeta.getVersion());
            if (newMeta.currentEnsemble.get(this.ensembleInfo.bookieIndex).equals(this.ensembleInfo.addr)) {
                if (!LedgerHandle.this.metadata.currentEnsemble.get(this.ensembleInfo.bookieIndex).equals(this.ensembleInfo.addr)) {
                    LOG.info("Resolve ledger metadata conflict while changing ensemble to: " + this.ensembleInfo.newEnsemble + ", old meta data is \n" + new String(LedgerHandle.this.metadata.serialize()) + "\n, new meta data is \n" + new String(newMeta.serialize()));
                    LedgerHandle.this.writeLedgerConfig(new ChangeEnsembleCb(this.ensembleInfo));
                }
            } else {
                LedgerHandle.this.blockAddCompletions.decrementAndGet();
                LedgerHandle.this.unsetSuccessAndSendWriteRequest(this.ensembleInfo.bookieIndex);
            }
            return true;
        }
    }

    private final class ChangeEnsembleCb
    extends OrderedSafeExecutor.OrderedSafeGenericCallback<Void> {
        private final EnsembleInfo ensembleInfo;

        ChangeEnsembleCb(EnsembleInfo ensembleInfo) {
            super(LedgerHandle.this.bk.mainWorkerPool, LedgerHandle.this.ledgerId);
            this.ensembleInfo = ensembleInfo;
        }

        @Override
        public void safeOperationComplete(int rc, Void result) {
            if (rc == -17) {
                LedgerHandle.this.rereadMetadata(new ReReadLedgerMetadataCb(rc, this.ensembleInfo));
                return;
            }
            if (rc != 0) {
                LOG.error("Could not persist ledger metadata while changing ensemble to: " + this.ensembleInfo.newEnsemble + " , closing ledger");
                LedgerHandle.this.handleUnrecoverableErrorDuringAdd(rc);
                return;
            }
            LedgerHandle.this.blockAddCompletions.decrementAndGet();
            LedgerHandle.this.unsetSuccessAndSendWriteRequest(this.ensembleInfo.bookieIndex);
        }
    }

    private static final class EnsembleInfo {
        private final ArrayList<InetSocketAddress> newEnsemble;
        private final int bookieIndex;
        private final InetSocketAddress addr;

        public EnsembleInfo(ArrayList<InetSocketAddress> newEnsemble, int bookieIndex, InetSocketAddress addr) {
            this.newEnsemble = newEnsemble;
            this.bookieIndex = bookieIndex;
            this.addr = addr;
        }
    }

    static class LastConfirmedCtx {
        static final long ENTRY_ID_PENDING = -10L;
        long response = -10L;
        int rc;

        LastConfirmedCtx() {
        }

        void setLastConfirmed(long lastConfirmed) {
            this.response = lastConfirmed;
        }

        long getlastConfirmed() {
            return this.response;
        }

        void setRC(int rc) {
            this.rc = rc;
        }

        int getRC() {
            return this.rc;
        }

        boolean ready() {
            return this.response != -10L;
        }
    }
}

