/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bk_v4_2_0.bookkeeper.client;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import org.apache.bk_v4_2_0.bookkeeper.client.DistributionSchedule;
import org.apache.bk_v4_2_0.bookkeeper.client.LedgerHandle;

public class LedgerFragment {
    private final int bookieIndex;
    private final List<InetSocketAddress> ensemble;
    private final long firstEntryId;
    private final long lastKnownEntryId;
    private final long ledgerId;
    private final DistributionSchedule schedule;
    private final boolean isLedgerClosed;

    LedgerFragment(LedgerHandle lh, long firstEntryId, long lastKnownEntryId, int bookieIndex) {
        this.ledgerId = lh.getId();
        this.firstEntryId = firstEntryId;
        this.lastKnownEntryId = lastKnownEntryId;
        this.bookieIndex = bookieIndex;
        this.ensemble = lh.getLedgerMetadata().getEnsemble(firstEntryId);
        this.schedule = lh.getDistributionSchedule();
        SortedMap<Long, ArrayList<InetSocketAddress>> ensembles = lh.getLedgerMetadata().getEnsembles();
        this.isLedgerClosed = lh.getLedgerMetadata().isClosed() || !((Object)this.ensemble).equals(ensembles.get(ensembles.lastKey()));
    }

    public boolean isClosed() {
        return this.isLedgerClosed;
    }

    long getLedgerId() {
        return this.ledgerId;
    }

    long getFirstEntryId() {
        return this.firstEntryId;
    }

    long getLastKnownEntryId() {
        return this.lastKnownEntryId;
    }

    public InetSocketAddress getAddress() {
        return this.ensemble.get(this.bookieIndex);
    }

    public int getBookiesIndex() {
        return this.bookieIndex;
    }

    public long getFirstStoredEntryId() {
        long firstEntry = this.firstEntryId;
        for (int i = 0; i < this.ensemble.size() && firstEntry <= this.lastKnownEntryId; ++firstEntry, ++i) {
            if (!this.schedule.hasEntry(firstEntry, this.bookieIndex)) continue;
            return firstEntry;
        }
        return -1L;
    }

    public long getLastStoredEntryId() {
        long lastEntry = this.lastKnownEntryId;
        for (int i = 0; i < this.ensemble.size() && lastEntry >= this.firstEntryId; --lastEntry, ++i) {
            if (!this.schedule.hasEntry(lastEntry, this.bookieIndex)) continue;
            return lastEntry;
        }
        return -1L;
    }

    public List<InetSocketAddress> getEnsemble() {
        return this.ensemble;
    }

    public String toString() {
        return String.format("Fragment(LedgerID: %d, FirstEntryID: %d[%d], LastKnownEntryID: %d[%d], Host: %s, Closed: %s)", this.ledgerId, this.firstEntryId, this.getFirstStoredEntryId(), this.lastKnownEntryId, this.getLastStoredEntryId(), this.getAddress(), this.isLedgerClosed);
    }
}

