/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bk_v4_2_0.bookkeeper.client;

import java.io.IOException;
import java.io.InputStream;
import org.jboss.bk_v4_2_0.netty.buffer.ChannelBufferInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LedgerEntry {
    Logger LOG = LoggerFactory.getLogger(LedgerEntry.class);
    long ledgerId;
    long entryId;
    long length;
    ChannelBufferInputStream entryDataStream;

    LedgerEntry(long lId, long eId) {
        this.ledgerId = lId;
        this.entryId = eId;
    }

    public long getLedgerId() {
        return this.ledgerId;
    }

    public long getEntryId() {
        return this.entryId;
    }

    public long getLength() {
        return this.length;
    }

    public byte[] getEntry() {
        try {
            byte[] ret = new byte[this.entryDataStream.available()];
            this.entryDataStream.readFully(ret);
            return ret;
        }
        catch (IOException e) {
            this.LOG.error("Unexpected IOException while reading from channel buffer", (Throwable)e);
            return new byte[0];
        }
    }

    public InputStream getEntryInputStream() {
        return this.entryDataStream;
    }
}

