/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bk_v4_2_0.bookkeeper.client;

import org.apache.bk_v4_2_0.bookkeeper.client.AsyncCallback;
import org.apache.bk_v4_2_0.bookkeeper.client.BookKeeper;
import org.apache.bk_v4_2_0.bookkeeper.util.OrderedSafeExecutor;
import org.apache.bk_v4_2_0.bookkeeper.versioning.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LedgerDeleteOp
extends OrderedSafeExecutor.OrderedSafeGenericCallback<Void> {
    static final Logger LOG = LoggerFactory.getLogger(LedgerDeleteOp.class);
    BookKeeper bk;
    long ledgerId;
    AsyncCallback.DeleteCallback cb;
    Object ctx;

    LedgerDeleteOp(BookKeeper bk, long ledgerId, AsyncCallback.DeleteCallback cb, Object ctx) {
        super(bk.mainWorkerPool, ledgerId);
        this.bk = bk;
        this.ledgerId = ledgerId;
        this.cb = cb;
        this.ctx = ctx;
    }

    public void initiate() {
        this.bk.getLedgerManager().removeLedgerMetadata(this.ledgerId, Version.ANY, this);
    }

    @Override
    public void safeOperationComplete(int rc, Void result) {
        this.cb.deleteComplete(rc, this.ctx);
    }
}

