/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bk_v4_2_0.bookkeeper.bookie;

import java.util.NavigableMap;
import java.util.Set;
import java.util.SortedMap;
import org.apache.bk_v4_2_0.bookkeeper.bookie.GarbageCollector;
import org.apache.bk_v4_2_0.bookkeeper.meta.LedgerManager;
import org.apache.bk_v4_2_0.bookkeeper.util.SnapshotMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanAndCompareGarbageCollector
implements GarbageCollector {
    static final Logger LOG = LoggerFactory.getLogger(ScanAndCompareGarbageCollector.class);
    private SnapshotMap<Long, Boolean> activeLedgers;
    private LedgerManager ledgerManager;

    public ScanAndCompareGarbageCollector(LedgerManager ledgerManager, SnapshotMap<Long, Boolean> activeLedgers) {
        this.ledgerManager = ledgerManager;
        this.activeLedgers = activeLedgers;
    }

    @Override
    public void gc(GarbageCollector.GarbageCleaner garbageCleaner) {
        NavigableMap<Long, Boolean> bkActiveLedgersSnapshot = this.activeLedgers.snapshot();
        LedgerManager.LedgerRangeIterator ledgerRangeIterator = this.ledgerManager.getLedgerRanges();
        try {
            if (!ledgerRangeIterator.hasNext()) {
                for (Long bkLid : bkActiveLedgersSnapshot.keySet()) {
                    bkActiveLedgersSnapshot.remove(bkLid);
                    garbageCleaner.clean(bkLid);
                }
            }
            while (ledgerRangeIterator.hasNext()) {
                LedgerManager.LedgerRange lRange = ledgerRangeIterator.next();
                SortedMap<Long, Boolean> subBkActiveLedgers = null;
                Long start = lRange.start();
                Long end = lRange.end();
                subBkActiveLedgers = end != -1L ? bkActiveLedgersSnapshot.subMap(start, true, end, true) : (start != -1L ? bkActiveLedgersSnapshot.tailMap(start) : bkActiveLedgersSnapshot);
                Set<Long> globalActiveLedgers = lRange.getLedgers();
                LOG.debug("All active ledgers for hash node {}, Current active ledgers from Bookie for hash node {}", globalActiveLedgers, subBkActiveLedgers.keySet());
                for (Long bkLid : subBkActiveLedgers.keySet()) {
                    if (globalActiveLedgers.contains(bkLid)) continue;
                    subBkActiveLedgers.remove(bkLid);
                    garbageCleaner.clean(bkLid);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Exception when iterating over the metadata {}", (Throwable)e);
        }
    }
}

