/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bk_v4_2_0.bookkeeper.bookie;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.bk_v4_2_0.bookkeeper.bookie.FileInfo;

public class LedgerEntryPage {
    private final int pageSize;
    private final int entriesPerPage;
    private long ledger = -1L;
    private long firstEntry = -1L;
    private final ByteBuffer page;
    private boolean clean = true;
    private boolean pinned = false;
    private int useCount;
    private int version;
    static final byte[] zeroPage = new byte[65536];

    public LedgerEntryPage(int pageSize, int entriesPerPage) {
        this.pageSize = pageSize;
        this.entriesPerPage = entriesPerPage;
        this.page = ByteBuffer.allocateDirect(pageSize);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getLedger());
        sb.append('@');
        sb.append(this.getFirstEntry());
        sb.append(this.clean ? " clean " : " dirty ");
        sb.append(this.useCount);
        return sb.toString();
    }

    public synchronized void usePage() {
        ++this.useCount;
    }

    public synchronized void pin() {
        this.pinned = true;
    }

    public synchronized void unpin() {
        this.pinned = false;
    }

    public synchronized boolean isPinned() {
        return this.pinned;
    }

    public synchronized void releasePage() {
        --this.useCount;
        if (this.useCount < 0) {
            throw new IllegalStateException("Use count has gone below 0");
        }
    }

    private synchronized void checkPage() {
        if (this.useCount <= 0) {
            throw new IllegalStateException("Page not marked in use");
        }
    }

    public boolean equals(Object other) {
        if (other instanceof LedgerEntryPage) {
            LedgerEntryPage otherLEP = (LedgerEntryPage)other;
            return otherLEP.getLedger() == this.getLedger() && otherLEP.getFirstEntry() == this.getFirstEntry();
        }
        return false;
    }

    public int hashCode() {
        return (int)this.getLedger() ^ (int)this.getFirstEntry();
    }

    void setClean(int versionOfCleaning) {
        this.clean = versionOfCleaning == this.version;
    }

    boolean isClean() {
        return this.clean;
    }

    public void setOffset(long offset, int position) {
        this.checkPage();
        ++this.version;
        this.clean = false;
        this.page.putLong(position, offset);
    }

    public long getOffset(int position) {
        this.checkPage();
        return this.page.getLong(position);
    }

    public void zeroPage() {
        this.checkPage();
        this.page.clear();
        this.page.put(zeroPage, 0, this.page.remaining());
        this.clean = true;
    }

    public void readPage(FileInfo fi) throws IOException {
        this.checkPage();
        this.page.clear();
        while (this.page.remaining() != 0) {
            if (fi.read(this.page, this.getFirstEntry() * 8L) > 0) continue;
            throw new IOException("Short page read of ledger " + this.getLedger() + " tried to get " + this.page.capacity() + " from position " + this.getFirstEntry() * 8L + " still need " + this.page.remaining());
        }
        this.clean = true;
    }

    public ByteBuffer getPageToWrite() {
        this.checkPage();
        this.page.clear();
        return this.page;
    }

    void setLedger(long ledger) {
        this.ledger = ledger;
    }

    long getLedger() {
        return this.ledger;
    }

    int getVersion() {
        return this.version;
    }

    void setFirstEntry(long firstEntry) {
        if (firstEntry % (long)this.entriesPerPage != 0L) {
            throw new IllegalArgumentException(firstEntry + " is not a multiple of " + this.entriesPerPage);
        }
        this.firstEntry = firstEntry;
    }

    long getFirstEntry() {
        return this.firstEntry;
    }

    public boolean inUse() {
        return this.useCount > 0;
    }

    public long getLastEntry() {
        for (int i = this.entriesPerPage - 1; i >= 0; --i) {
            if (this.getOffset(i * 8) <= 0L) continue;
            return (long)i + this.firstEntry;
        }
        return 0L;
    }
}

