/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bk_v4_2_0.bookkeeper.bookie;

import com.google.bk_v4_2_0.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.apache.bk_v4_2_0.bookkeeper.bookie.Bookie;
import org.apache.bk_v4_2_0.bookkeeper.conf.ServerConfiguration;
import org.apache.bk_v4_2_0.bookkeeper.util.DiskChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LedgerDirsManager {
    private static Logger LOG = LoggerFactory.getLogger(LedgerDirsManager.class);
    private volatile List<File> filledDirs;
    private final List<File> ledgerDirectories;
    private volatile List<File> writableLedgerDirectories;
    private DiskChecker diskChecker;
    private List<LedgerDirsListener> listeners;
    private LedgerDirsMonitor monitor;
    private final Random rand = new Random();

    public LedgerDirsManager(ServerConfiguration conf) {
        this.ledgerDirectories = Arrays.asList(Bookie.getCurrentDirectories(conf.getLedgerDirs()));
        this.writableLedgerDirectories = new ArrayList<File>(this.ledgerDirectories);
        this.filledDirs = new ArrayList<File>();
        this.listeners = new ArrayList<LedgerDirsListener>();
        this.diskChecker = new DiskChecker(conf.getDiskUsageThreshold());
        this.monitor = new LedgerDirsMonitor(conf.getDiskCheckInterval());
    }

    public List<File> getAllLedgerDirs() {
        return this.ledgerDirectories;
    }

    public List<File> getWritableLedgerDirs() throws NoWritableLedgerDirException {
        if (this.writableLedgerDirectories.isEmpty()) {
            String errMsg = "All ledger directories are non writable";
            NoWritableLedgerDirException e = new NoWritableLedgerDirException(errMsg);
            LOG.error(errMsg, (Throwable)e);
            throw e;
        }
        return this.writableLedgerDirectories;
    }

    public boolean isDirFull(File dir) {
        return this.filledDirs.contains(dir);
    }

    @VisibleForTesting
    public void addToFilledDirs(File dir) {
        if (!this.filledDirs.contains(dir)) {
            LOG.warn(dir + " is out of space." + " Adding it to filled dirs list");
            ArrayList<File> updatedFilledDirs = new ArrayList<File>(this.filledDirs);
            updatedFilledDirs.add(dir);
            this.filledDirs = updatedFilledDirs;
            ArrayList<File> newDirs = new ArrayList<File>(this.writableLedgerDirectories);
            newDirs.removeAll(this.filledDirs);
            this.writableLedgerDirectories = newDirs;
            for (LedgerDirsListener listener : this.listeners) {
                listener.diskFull(dir);
            }
        }
    }

    File pickRandomWritableDir() throws NoWritableLedgerDirException {
        return this.pickRandomWritableDir(null);
    }

    File pickRandomWritableDir(File excludedDir) throws NoWritableLedgerDirException {
        int start;
        List<File> writableDirs = this.getWritableLedgerDirs();
        int idx = start = this.rand.nextInt(writableDirs.size());
        File candidate = writableDirs.get(idx);
        while (null != excludedDir && excludedDir.equals(candidate)) {
            if ((idx = (idx + 1) % writableDirs.size()) == start) {
                throw new NoWritableLedgerDirException("No writable directories found from  available writable dirs (" + writableDirs + ") : exclude dir " + excludedDir);
            }
            candidate = writableDirs.get(idx);
        }
        return candidate;
    }

    public void addLedgerDirsListener(LedgerDirsListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void start() {
        this.monitor.setDaemon(true);
        this.monitor.start();
    }

    public void shutdown() {
        this.monitor.interrupt();
        try {
            this.monitor.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static /* synthetic */ List access$000(LedgerDirsManager x0) {
        return x0.listeners;
    }

    static /* synthetic */ DiskChecker access$100(LedgerDirsManager x0) {
        return x0.diskChecker;
    }

    static /* synthetic */ Logger access$200() {
        return LOG;
    }

    public static interface LedgerDirsListener {
        public void diskFailed(File var1);

        public void diskFull(File var1);

        public void allDisksFull();

        public void fatalError();
    }

    public static class NoWritableLedgerDirException
    extends IOException {
        private static final long serialVersionUID = -8696901285061448421L;

        public NoWritableLedgerDirException(String errMsg) {
            super(errMsg);
        }
    }

    private class LedgerDirsMonitor
    extends Thread {
        int interval;

        public LedgerDirsMonitor(int interval) {
            this.interval = interval;
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (true) lbl-1000:
                // 2 sources

                {
                    try {
                        writableDirs = LedgerDirsManager.this.getWritableLedgerDirs();
                    }
                    catch (NoWritableLedgerDirException e) {
                        i$ = LedgerDirsManager.access$000(LedgerDirsManager.this).iterator();
                        while (i$.hasNext() != false) {
                            listener = (LedgerDirsListener)i$.next();
                            listener.allDisksFull();
                        }
                        return;
                    }
                    for (File dir : writableDirs) {
                        try {
                            LedgerDirsManager.access$100(LedgerDirsManager.this).checkDir(dir);
                        }
                        catch (DiskChecker.DiskErrorException e) {
                            for (LedgerDirsListener listener : LedgerDirsManager.access$000(LedgerDirsManager.this)) {
                                listener.diskFailed(dir);
                            }
                        }
                        catch (DiskChecker.DiskOutOfSpaceException e) {
                            LedgerDirsManager.this.addToFilledDirs(dir);
                        }
                    }
                    try {
                        Thread.sleep(this.interval);
                        continue;
                    }
                    catch (InterruptedException e) {
                        LedgerDirsManager.access$200().info("LedgerDirsMonitor thread is interrupted");
                        return;
                    }
                    break;
                }
            }
            catch (Exception e) {
                LedgerDirsManager.access$200().error("Error Occured while checking disks", (Throwable)e);
                i$ = LedgerDirsManager.access$000(LedgerDirsManager.this).iterator();
                while (i$.hasNext() != false) {
                    listener = (LedgerDirsListener)i$.next();
                    listener.fatalError();
                }
                return;
            }
            {
                ** while (true)
            }
        }
    }
}

